#include "mbed.h"
#include "control.h"
#include "behaviour.h"

void CONTROL_OnOff(CONTROLLER* control)
{
    if(control->presentvalue > control->setpoint)
        control->output = control->upperlimit;//upperlimit is negative value
    else
    if(control->presentvalue < control->setpoint)
        control->output = control->lowerlimit;
    else
        control->output = 0.0;
}

void CONTROL_P(CONTROLLER* control)
{       
    control->error = control->setpoint - control->presentvalue;
    control->error_p = control->error;  
    control->output = control->gain_p * control->error_p;
    
    if(control->output < control->lowerdeadband || control->output > control->upperdeadband)
    {   
        if(control->output < control->lowerlimit) 
            control->output = control->lowerlimit;  
        if(control->output > control->upperlimit) 
            control->output = control->upperlimit;
    }
    else
        control->output = 0.0;
}

void CONTROL_PI(CONTROLLER* control)
{
    double error_old;
    
    error_old = control->error;
    control->error = control->setpoint - control->presentvalue;
    
    control->error_p = control->error;
    control->error_i += error_old;
    control->output = (control->gain_p * control->error_p)+(control->gain_i * control->error_i);

    if(control->output < control->lowerdeadband || control->output > control->upperdeadband)
    {   
        if(control->output < control->lowerlimit) 
            control->output = control->lowerlimit;  
        if(control->output > control->upperlimit) 
            control->output = control->upperlimit;
    }
    else
        control->output = 0.0;
}

void CONTROL_PD(CONTROLLER* control)
{
    double error_old;
    
    error_old = control->error;
    control->error = control->setpoint - control->presentvalue;
    control->error_p = control->error;
    control->error_d = control->error - error_old;
    control->output = (control->gain_p * control->error_p)+(control->gain_d * control->error_d);

    if(control->output < control->lowerdeadband || control->output > control->upperdeadband)
    {   
        if(control->output < control->lowerlimit) 
            control->output = control->lowerlimit;  
        if(control->output > control->upperlimit) 
            control->output = control->upperlimit;
    }
    else
        control->output = 0.0;
}

void CONTROL_PID(CONTROLLER* control)
{
    double error_old;
    
    error_old = control->error;
    control->error = control->setpoint - control->presentvalue;
    
    control->error_p = control->error;
    control->error_i += error_old;
    control->error_d = control->error - error_old;
    control->output = (control->gain_p * control->error_p)+(control->gain_i * control->error_i)+(control->gain_d * control->error_d);

    if(control->output < control->lowerdeadband || control->output > control->upperdeadband)
    {   
        if(control->output < control->lowerlimit) 
            control->output = control->lowerlimit;  
        if(control->output > control->upperlimit) 
            control->output = control->upperlimit;
    }
    else
        control->output = 0.0;
}

void CONTROL_InputMode_Set(CONTROLLER* control, unsigned char input, double mode)
{
    control->input = input;
    control->mode = mode;
}
void CONTROL_Setpoint_Set(CONTROLLER* control, double sp)
{
    control->setpoint = sp;
}
void CONTROL_Gain_Set(CONTROLLER* control, double p, double i, double d)
{
    control->gain_p = p;
    control->gain_i = i;
    control->gain_d = d;
}
void CONTROL_Limit_Set(CONTROLLER* control, double upper, double lower)
{
    control->upperlimit = upper;
    control->lowerlimit = lower;
}
void CONTROL_Deadband_Set(CONTROLLER* control, double upper, double lower)
{
    control->upperdeadband = upper;
    control->lowerdeadband = lower;
}

void CONTROL_PresentValue_Set(CONTROLLER* control, double pv)
{
    control->presentvalue = pv;
}
    
double CONTROL_Output_Get(CONTROLLER* control)
{
    switch(control->mode)
    {
        case CONTROL_MODE_NONE:
            break;
        case CONTROL_MODE_ONOFF:
            CONTROL_OnOff(control);
            break;
        case CONTROL_MODE_P:
            CONTROL_P(control);
            break;
        case CONTROL_MODE_PI:
            CONTROL_PI(control);
            break;
        case CONTROL_MODE_PD:
            CONTROL_PD(control);
            break;
        case CONTROL_MODE_PID:
            CONTROL_PID(control);
            break;      
    }
    return control->output; 
}    

void CONTROL_Config(void)
{
}

void CONTROL_Task(void)                                         
{

}