#include "LSM6DSLSensor.h"
#include "accgyro.h"
#include "mbed.h"
#include "rtos.h"

//Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
int32_t ACCGYRO_gyro_axes[3];
int32_t ACCGYRO_acc_axes[3];
static DevI2C devI2c(PB_11,PB_10);
static LSM6DSLSensor acc_gyro(&devI2c,LSM6DSL_ACC_GYRO_I2C_ADDRESS_LOW,PD_11);
EventQueue ACCGYRO_queue;
Mutex ACCGYRO_mutex;

int32_t ACCGYRO_get_gyro_x()
{
    int32_t temp;
    //ACCGYRO_mutex.lock();
    temp = ACCGYRO_gyro_axes[0];
    //ACCGYRO_mutex.unlock();
    return temp;
}

void ACCGYRO_task()
{
    led1 = !led1;
    //ACCGYRO_mutex.lock();
    acc_gyro.get_x_axes(ACCGYRO_gyro_axes);
    acc_gyro.get_g_axes(ACCGYRO_acc_axes);
    //ACCGYRO_mutex.unlock();
    //pc.printf("LSM6DSL [acc/mg]:        %6ld\r\n", ACCGYRO_gyro_axes[0]);
};

void ACCGYRO_init()
{
    //pc.printf("Initing LSM6DSL\r\n", ACCGYRO_gyro_axes[0]);
    acc_gyro.init(NULL);
    acc_gyro.enable_x();
    acc_gyro.enable_g();
    //RtosTimer ACCGYRO_Timer(&ACCGYRO_task,osTimerPeriodic);
    //ACCGYRO_Timer.start(100);
    //pc.printf("Init done\r\n");
    //ACCGYRO_queue.call_every(1000, ACCGYRO_task);
    //ACCGYRO_queue.dispatch();
};
