#include "ADC0848.h"


unsigned char A2DValue[8] = {0,0,0,0,0,0,0,0};

//ADC0848 Class Constructor for polling A2D using int ADC0848::Poll_A2D(unsigned char Channel)
ADC0848::ADC0848(PinName pin1, PinName pin2, PinName pin3, PinName pin4, PinName pin5, PinName pin6, PinName pin7, PinName pin8, PinName pin9, PinName pin10, PinName pin11) 
								:_DataBus(pin1,pin2,pin3,pin4,pin5,pin6,pin7,pin8), _WR(pin9), _RD(pin10),_intS(NC),_intP(pin11)
{
	_WR = 1;
	_RD = 1;
  _intP.mode(PullUp);	
	_scan = false;
}
//ADC0848 Class Constructor for scanning all channels of continues using interrupts A2D vales can be using int ADC0848::GetA2D(unsigned char Channel)
//char ADC0848::Start_Scan() must be called to start a conversion
ADC0848::ADC0848(PinName pin1, PinName pin2, PinName pin3, PinName pin4, PinName pin5, PinName pin6, PinName pin7, PinName pin8, PinName pin9, PinName pin10, PinName pin11,bool Scan) 
								:_DataBus(pin1,pin2,pin3,pin4,pin5,pin6,pin7,pin8), _WR(pin9), _RD(pin10),_intS(pin11),_intP(NC), _scan(Scan)
{
	_WR = 1;
	_RD = 1;
  _intS.mode(PullUp);
	_intS.fall_add(this,&ADC0848::DIGI_IO_ISR);		
}


void ADC0848::DIGI_IO_ISR() // ISR used if in scanning mode to scan the 8 channels of the ADC  The values are stored in unsigned char A2DValue[8]
{
	static unsigned char channel_num=0;
  _DataBus.input();
	_RD = 0;
	A2DValue[channel_num] = _DataBus;
	_RD = 1;
	channel_num++;
	if(channel_num > 7)
		 channel_num=0;
	_DataBus.output();
	_DataBus=0x08 | channel_num;
	_WR = 0;
	_WR = 1;
}

int ADC0848::Start_Scan()  
{
 if(_scan)
 {
	_DataBus.output(); //start 1st conversion 
	_DataBus=0x08;
	_WR = 0;
	_WR = 1;
	return(1);
 }
 else
 {
	return(-1);
 }
}

int ADC0848::GetA2D(unsigned char Channel)  //Returns the Value of the the channel requested when in scanning mode.  If not in scanning mode the function returns -1
{
		if(_scan)
		{
	   return((int)A2DValue[Channel]);
		}
		else
		{
			return(-1);
		}
}

int ADC0848::Poll_A2D(unsigned char Channel) //Returns the Value of the the channel requested when in polling mode.  If not in polling mode the function returns -1
{
	if(!_scan)
	{
		char data;
		_DataBus.output();
		_DataBus=0x08 | Channel;
		_WR = 0;
		_WR = 1;
		while(_intP);
		_DataBus.input();
		_RD = 0;
		data = _DataBus;
		_RD = 1;
		return ((int)data);
	}
	else
	{
		return(-1);
	}
}


