#include "BMP085.h"

I2C i2c(p28, p27);

int _SlaveA;                    //local variable that holds the Slave Address

int  AC1,AC2,AC3,B1,B2,MB,MC,MD;
int AC4,AC5,AC6;
long B5;


char _SensorData[8] ={100,100,100};  //Char array that holds the current Altitude and Temperature dat



//BMP085 Class Constructor
BMP085::BMP085 (int SlaveAddress, PinName sda, PinName scl, PinName EOC) : _i2c(sda,scl), _eoc(EOC)
{
		_eoc.mode(PullUp);
		_SlaveA = SlaveAddress;
		
}


int BMP085::Write_Register (char regnum, char data)   //Used for writing data to the BMP085 Registers
{
		char Write_Data[2];
		Write_Data[0] = regnum;
		Write_Data[1] = data;
		return(_i2c.write(_SlaveA, Write_Data, 2));
}

int BMP085::Read_Register (char regnum, int numbofbytes)   //
{
		char Write_Data[1];    
	  Write_Data[0] = regnum;
	  _i2c.write(_SlaveA, Write_Data, 1,true);
	  _i2c.read(_SlaveA, _SensorData, numbofbytes);	
		return(1);

}

int BMP085::Read_ConversionValue(unsigned char type)     //
{
      Write_Register(0xF4,type);
	    for(int t=0; t<5000;t++);
			while(!_eoc);
			Read_Register(0xF6,2);
			return (((int)_SensorData[0]*256+_SensorData[1]));		
}

void BMP085::GetCalibrationData()
{
			
			AC1=(int)return16bit(0xAA);
				
			AC2=(int)return16bit(0xAC);
			
			AC3=(int)return16bit(0xAE);
			
			AC4=return16bit(0xB0);
			
		  AC5=return16bit(0xB2);

			AC6=return16bit(0xB4);

			B1=(int)return16bit(0xB6);

			B2=(int)return16bit(0xB8);
			
			MB=(int)return16bit(0xBA);
			
			MC=(int)return16bit(0xBC);
			
			MD=(int)return16bit(0xBE);		
}

int BMP085::return16bit(int Reg)     //Read Data Register from MPL3115A2 Sensor
{  
	  Read_Register(Reg,2);
	  return ((int)(_SensorData[0]*256+_SensorData[1]));
}


int BMP085::calculate_tempc()
{
	long X1;
	long X2;
	int tempin;
	tempin=Read_ConversionValue(Temp);
	if(tempin>0)
	{
	X1=(long)((long)tempin-AC6)*AC5/32768;
	X2=(long)MC*2048/(X1+MD);
	B5=X1+X2;
	return((B5+8)/16);
	//return(tempin);	
	}
	return (0);
}

int BMP085::calculate_pressure()
{
	long B6, X1,X2,X3,B3,P;
  unsigned long B4,B7;
	int presin;
	presin=Read_ConversionValue(Pressure);
	
	if(presin>0)
	{	
		B6=B5-4000;
		X1=(B2*(B6*B6/4096))/2048;
		X2=AC2*B6/2048;
		X3=X1+X2;
		B3=(AC1*4+X3)/4;
		X1=(long)AC3*B6/8192;
		X2=((long)B1*(B6*B6/4096))/65536;
		X3=((X1+X2)+2)/4;
		B4=(long)AC4*(X3+32768)/32768;
		B7=((long)presin-B3)*(50000);
		if(B7<0X80000000)
		{
				P=(B7*2)/B4;
		}
		else
		{
			P = (B7/B4)*2;
		}
		X1 = (P/256)*(P/256);
		X1 = (X1*3038)/65536;
		X2 = (-7357*P)/65536;
		P=P + (X1 + X2 + 3792)/16;
		P=P/1000;
		return ((int)P);
 }
 return(0);
}







