#include "mbed.h"
#include "PwmOutAny.h"

 Timer t;

 InterruptIn SquareIn (p22);
 DigitalOut status (LED1);



PwmOutAny newPwm (p25,.0001,.50);

void measure_Period()    // this is a test function it looks at a square wave on pin p22 and uses its freq. as the base freq. for the PWM.
{
	static bool first = true;
	static float InputPeriod = .0001;
  static unsigned int count = 0;
	if(first)
	{
		t.reset();
		t.start();
		first = false;
	}
	else
	{
		
		InputPeriod = (InputPeriod + t.read())/2;
		newPwm.Set_Period(InputPeriod);
		status = ! status;
		t.reset();
		t.start();
		count++;
	}
	
}


int main()
	{
	
    SquareIn.rise(&measure_Period);
		
		while(1)
		{
    for(float t=0;t<=1;t+=.01)
			{
				newPwm.Set_PulseWidth(t);
				wait(.1);
			}
		for(float t=1;t>=0;t-=.01)
			{
				newPwm.Set_PulseWidth(t);
				wait(.1);
			}

			
		}
		
	}	

