#include "mbed.h"
#include "MorseCode.h"
float unit = .005;

const char Letters[37][7] = {
										{2,1,0}, //a
										{4,0,1,1,1},//b
										{4,0,1,0,1},//c
										{3,0,1,1},//d
										{1,1},//e
										{4,1,1,0,1},//f
										{3,0,0,1},//g
										{4,1,1,1,1},//h
										{2,1,1},//i
										{4,1,0,0,0},//j
										{3,0,1,0},//k
										{4,1,0,1,1},//l
										{2,0,0},//m
										{2,0,1},//n
										{3,0,0,0},//o
										{4,1,0,0,1},//p
										{4,0,0,1,0},//q
										{3,1,0,1},//r
										{3,1,1,1},//s
										{1,0},//t
										{3,1,1,0},//u
										{4,1,1,1,0},//v
										{3,1,0,0},//w
										{4,0,1,1,0},//x
										{4,0,1,0,0},//y
										{4,0,0,1,1},//z
										{5,0,0,0,0,0},//0
										{5,1,0,0,0,0},//1
										{5,1,1,0,0,0},//2
										{5,1,1,1,0,0},//3
										{5,1,1,1,1,0},//4
										{5,1,1,1,1,1},//5
										{5,0,1,1,1,1},//6
										{5,0,0,1,1,1},//7
										{5,0,0,0,1,1},//8
										{5,0,0,0,0,1},//9	
										{0}//space
};


 MorseCode::MorseCode(PinName pin): _pin(pin) //Constructor
 {    
   
 }
 
float MorseCode::get_unit()
{
	return (unit);
}
void MorseCode::set_unit(float secs)
{
	unit = secs;
}

void MorseCode::blink_buffer (unsigned char* Pbuffer)  //Blink out String
{
	unsigned char next_letter;
	unsigned int i=0;
	while (Pbuffer[i] !=  0)
	{
				next_letter = Pbuffer[i];
        Print_ASCII_Char(next_letter);	
				i++;	
	}
}


void MorseCode::blink_letter (unsigned int letter)  //Blink out a single Ascii letter
{
	if(letter == 36)
	{
		wait(unit*4);  //space between words (3 + 4 = 7 units)
	}
	for(int i = 1; i<(int)((Letters[letter][0])+1);i++)
	{
		if(Letters[letter][i])
		{
			Dot();
		}
		else
		{
			Dash();
		}
	}
	wait(unit*3);  //space between letters
}

void MorseCode::Dot()  //Sets Blink Duration for Dot
{
	_pin=1;
	wait (unit);
	_pin = 0;
	wait (unit);
}

void MorseCode::Dash()  //Sets Blink Duration for Dash
{
	_pin =1;
	wait ((unit * 3.0));
	_pin = 0;
	wait (unit);
}

bool MorseCode::Print_ASCII_Char(unsigned char letter)  //Determines if the ASCII value is valid and it calls blink_letter with the correct char value Upper/Lower/Numbers/Space
{
	if(letter >= 0x61  && letter <= 0x7a)
	{
		 blink_letter(letter-0x61);    // it is lowercase
	}
	else if(letter >= 0x41 && letter <= 0x5a)  
	{
		 blink_letter(letter-0x41);  // it is in caps
	}
	else if (letter >= 0x30 && letter <= 0x39)
	{
		 blink_letter(letter-0x22 );  // it is a number
	}
	else if (letter == 0x20)
	{
		 blink_letter(36); //it is a space
	}
	else
	{
		return(false);
	}
	return(true);
}
