#include "mbed.h"
#include "MPL3115A2.h"

Serial pc(USBTX, USBRX);

char I2C_Read[8];
const int SlaveAddressI2C = 0xC0;  //This is the slave address of the device

MPL3115A2 Sensor1(SlaveAddressI2C, p28, p27, p21, p22);


int main()
{
    int status = -1;
    if(!Sensor1.Init())
		{
			pc.printf("Altimeter Initialized\n\r");
		}
		else
		{
			pc.printf("Altimeter Failed To Initialize\n\r");
			while(1);
		}

    while(true)
		{   // this is the third thread
        if(Sensor1.get_int1())
 				{
						status = -1;
  					status = Sensor1.Read_Altitude_Data();
						pc.printf("Altitude: %f ft\n\r",Sensor1.Altitude_ft());
						pc.printf("Temp: %f Deg\n\r",Sensor1.Temp_F());
						wait(1);
				}
    }
}

