
#include "mbed.h"
#include "MPL3115A2.h"


	int _SlaveA;					//local variable that holds the Slave Address
  char _SensorData[8];  //Char array that holds the current Altitude and Temperature data
	
	//MPL3115A2 Class Constructor
	MPL3115A2::MPL3115A2(int SlaveAddress, PinName pin1, PinName pin2, PinName pin3, PinName pin4) : _i2c(pin1,pin2), _pin1(pin3),_pin2(pin4)
	{
		_pin1.mode(PullUp);
		_pin2.mode(PullUp);
		_SlaveA = SlaveAddress;
		
	}

	int MPL3115A2::Write_Register (char regnum, char data)   //Used for writing data to the MPL3115A2 Registers
	{
		char Write_Data[2];
		Write_Data[0] = regnum;
		Write_Data[1] = data;
    return(_i2c.write(_SlaveA, Write_Data, 2));
	}
	
	int MPL3115A2::Read_Altitude_Data()		//Read Data Register from MPL3115A2 Sensor
	{
		char Start_Register [] = {0x01};
	  _i2c.write(_SlaveA, Start_Register, 1,true);
		return(_i2c.read(_SlaveA, _SensorData, 5));
		
	}
	
	bool MPL3115A2::get_int1 ()   //Return state of Int1 pin
	{
		return(_pin1.read());
	}
	
	bool MPL3115A2::get_int2 ()	  //Return state of Int2 pin
	{
		return(_pin2.read());
	}
	
	float MPL3115A2::Altitude_ft () //Return Altitude in Feet
	{
		return((((_SensorData[2]>>4)/128.0)+ (_SensorData[0]*256+_SensorData[1]))*3.28);
	}
	
	float MPL3115A2::Altitude_m ()	//Return Altitude in meters
	{
		return((((_SensorData[2]>>4)/128.0)+ (_SensorData[0]*256+_SensorData[1])));
	}
	
	float MPL3115A2::Temp_F ()		//Return Temp in Degrees F
	{
		return(((_SensorData[4]>>4)/128.0+(float)_SensorData[3])*(1.8)+32.0);
	}
	
	float MPL3115A2::Temp_C ()		//Return Temp in Degrees C
	{
		return(((_SensorData[4]>>4)/128.0+(float)_SensorData[3]));
	}
	
	int MPL3115A2::Init ()			//Initialize the MPL3115A2 in Alitude Interrupt Mode
	{
		  int status = -1;
	    status = Write_Register(0x26,0xB8);

			if(status==0)
			{
				status = -1;
				status = Write_Register(0x13,0x07);
			}
			
			if(status==0)
			{	    
				status = -1;
				status = Write_Register(0x2d,OFFSET);
			}
			
			if(status==0)
			{
				status = -1;
				status = Write_Register(0x28,0x11);
			}
			
			if(status==0)
			{	
				status = -1;
				status = Write_Register(0x29,0x80);
			}
			
			if(status==0)
			{	
				status = -1;
				status = Write_Register(0x26,0xB9);
			}
 	    return(status);
		
	}
	
	
	
