
#include "mbed.h"
#include "LKM1638.h"


const char READMODE = 0x42;
const char INTENSITY = 0x00;  //Intensity of LED and Seven Segment Displays (0-7)
const int WAIT = 1;

	
	//MPL3115A2 Class Constructor
	LKM1636::LKM1636(PinName pin1, PinName pin2, PinName pin3) :_Strobe(pin1),_CLK(pin2),_Data(pin3)
	{
	  _Data.mode(PullUp);
		
	}

	
//Driver Function that is used to write any printable char to the seven segment displays 0-7
void LKM1636::displaychar (unsigned char value, unsigned char Seg_num, bool decimal)	 //Seg_num 0-7 ____,____
{

	unsigned char address;
	unsigned char Seg_value=0;
	address = 0xC0 + Seg_num * 2;		  //Base Address for Segments is 0xC0 Each segment uses to Bytes of Mem.
	Seg_value = getchar(value);
	if(decimal)
	Seg_value = Seg_value | 0x80;
	if(Seg_value<0xff)					  // If Seg_value == 0xFF then character was not recognized
	{
	 	_Strobe = 0;
		SendChar(address);
		SendChar(Seg_value);
		_Strobe = 1;
		Delay(WAIT);
		_Strobe = 0;
		SendChar(INTENSITY | 0x88);
	  _Strobe = 1;
	}



}


//Prints a Long int to the 8 Seven Segment displays
void LKM1636::Clear()	 //bank is either Seven Segs 0-3 Bank==0 or Segs 4-7 Bank==1
	{
		unsigned long temp1=0;
		
    for(temp1=0;temp1<8;temp1++)
		{
					displaychar (' ',temp1,0);
		}

	}



///Writes an 8bool number to either the first or second bank of 4 seven segment displays

void LKM1636::Write_Short(unsigned char value, bool bank)	 //bank is either Seven Segs 0-3 Bank==0 or Segs 4-7 Bank==1
	{
		unsigned char temp=0;
		unsigned char Seg_number = 0; 
		if(bank)
		Seg_number = 5;
		temp = value/100;
		temp = temp%10;
		displaychar (temp, Seg_number,0);
		temp = value/10;
		temp = temp%10;
		displaychar (temp, Seg_number+1,0);
		temp = value%10;
		displaychar (temp, Seg_number+2,0);
	}
//Prints a Long int to the 8 Seven Segment displays
void LKM1636::Write_Long(unsigned long int value)	 //bank is either Seven Segs 0-3 Bank==0 or Segs 4-7 Bank==1
	{
		unsigned long temp1=0;
		
		temp1 = (value/10000000);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,0,0);

		temp1 = (value/1000000);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,1,0);

		temp1 = (value/100000);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,2,0);

		temp1 = (value/10000);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,3,0);

		temp1 = (value/1000);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,4,0);

		temp1 =(value/100);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,5,0);

		temp1 = (value/10);
		temp1 = temp1%10;
		displaychar ((unsigned char)temp1,6,0);

		temp1 = (value%10);
		displaychar ((unsigned char)temp1,7,0);
	}

// Serializes the Value passed into the character variable and send out using the data pin
void LKM1636::SendChar(unsigned char Character)
{
 	    unsigned char t;
		_CLK =1;
	  _Data.output();
		Delay(WAIT);
		for (t=0;t<8;t++)				  //Serialize Address and put out on Data Pin
		{

  		 _Data = (Character & 0x01);
		   Character = Character>>1;
		   ToggleClock (); 		
		}
		_Data.input();

}
///  Toggles the Clock pin low to high with a minimal delay between the toggle
void LKM1636::ToggleClock ()
{
		   _CLK = 0;
		   Delay(WAIT);
		   _CLK = 1;	
		   Delay(WAIT);
}
/// Delay for Tick * Tocks of system clock
///
void LKM1636::Delay(unsigned int Tick)
{
 	unsigned int tock=0,t=0;
	for(t=0;t<Tick;t++)
	{
	  for(tock=0;tock<10;tock++);
	}

}

/// Getchar takes a integer value 0-15 or ascii value '0' - 'F'
/// and returns the Seven Segment value needed to display the value

unsigned char LKM1636::getchar(unsigned char value)
{
	int seg_value = 0;

 	switch(value)
	{
	 	case ('0'):
		case (0):
			seg_value = 0x3f;
			break;			
		case ('1'):
		case (1):
			seg_value = 0x6;
			break;
		case ('2'):
		case (2):
			seg_value = 0x5b;
			break;
		case ('3'):
		case (3):
			seg_value = 0x4f;
			break;
		case ('4'):
		case (4):
			seg_value = 0x66;
			break;
		case ('5'):
		case (5):
			seg_value = 0x6d;
			break;
		case ('6'):
		case (6):
			seg_value = 0x7d;
			break;
		case ('7'):
		case (7):
			seg_value = 0x7;
			break;
		case ('8'):
		case (8):
			seg_value = 0x7f;
			break;
		case ('9'):
		case (9):
			seg_value = 0x6f;
			break;
		case ('A'):
		case ('a'):
		case (10):
			seg_value = 0x77;
			break;
		case ('B'):
		case ('b'):
		case (11):
			seg_value = 0x7c;
			break;
		case ('C'):
		case ('c'):
		case (12):
			seg_value = 0x39;
			break;
		case ('D'):
		case ('d'):
		case (13):
			seg_value = 0x5e;
			break;
		case ('E'):
		case ('e'):
		case (14):
			seg_value = 0x79;
			break;
		case ('F'):
		case ('f'):
		case (15):
			seg_value = 0x71;
			break;
		case ('.'):
			seg_value = 0x80;
			break;
		case ('-'):
			seg_value = 0x40;
			break;
		case (' '):
			seg_value =0x0;
			break;
		default :
			seg_value = 0xff;
			break;
			
	}
	return (seg_value);
}

//Reads the current state of all 8 input buttons.  The state of each button is returned as an 8bool value
//the bool to Sw map:
//Switch bool order   bool# 7 6 5 4 3 2 1 0  //0x80 0x20 0x08 0x02 || 0x40 0x10 0x04 0x01
//					 Sw#  1 5 2 6 3 7 4 8

unsigned char LKM1636::read_buttons ()
{
    unsigned char temp=0;
	char d=0;
    _Strobe = 0;
	SendChar(READMODE);
	//_Data = 1;
	_CLK = 1;
	Delay(WAIT);
	for(d=0;d<32;d++)
	{
	   if(!((d-1)%4))
	   {
			temp=temp<<1;
			if(_Data)
	   		temp+=1;	   	
	   }
	   ToggleClock ();
	}
	_Strobe = 1;
	return temp;	
}					 
					 
//Takes the 8bool number returned from the read_buttons function and lights the corsponing LED to current switch posistion
void LKM1636::Switch_To_LED(unsigned char Switch_Values)
{
    unsigned char t=0;
	bool temp_state=0;
    for(t=0; t<8; t++)
	{
	 	temp_state = (Switch_Values & 0x01);
	 	Switch_Values= Switch_Values>>1;
	 	switch (t)
		{
		    case (0):
		    LED (7, temp_state);		
			break;
		   	case (1):
		    LED (3, temp_state);		
			break;
		   	case (2):
		    LED (6, temp_state);		
			break;
		   	case (3):
		    LED (2, temp_state);		
			break;
		   	case (4):
		    LED (5, temp_state);		
			break;
		   	case (5):
		    LED (1, temp_state);		
			break;
		   	case (6):
		    LED (4, temp_state);		
			break;
		   	case (7):
		    LED (0, temp_state);		
			break;
			default:
			break;
		}

	}
}

//LED_Num (0-7)) corsponds to the LED that is to be written to state(1=led on, 0 = led off)
void LKM1636::LED (unsigned char LED_Num, bool state)//intensity can range from 0-7
{
 	unsigned char LED_Address;
	LED_Address = 0xC0 + (LED_Num*2) + 1;   //LED are at odd address 1 to 15;
	_Strobe = 0;
	SendChar(LED_Address);
	if(state)
	SendChar(0x01);
	else
	SendChar(0x00);
	_Strobe = 1;
	Delay(WAIT);
	_Strobe = 0;
	SendChar(INTENSITY | 0x88);
	_Strobe = 1;
}
//Takes a 8bool number and writes out the value to the 8 leds (0-7)
void LKM1636::LEDS (unsigned char LED_Values)
{
   unsigned char temp;
   bool temp_state = 0 ;
   for(temp=0; temp<8; temp++)
   {
   	 temp_state = (LED_Values & 0x01);
	 LED (temp, temp_state);
	 LED_Values= LED_Values>>1;
   }
}
