#include "DebouncedIn.h"
#include "mbed.h"

#define CHECK_MSEC 5 // Read hardware every 5 msec 
#define PRESS_MSEC 100 // Stable time before registering pressed 
#define RELEASE_MSEC 100 // Stable time before registering released
 

bool DebounceKeyPress = false;
 /*v
  * Constructor
  */
 DebouncedIn::DebouncedIn(PinName pin): _pin(pin)
 {    
	  _pin.mode(PullDown);
    _poll.attach(this, &DebouncedIn::CheckState, 0.005);     
 }
 
 bool DebouncedIn::get()
 {
	 return(DebounceKeyPress);
 }
 
 bool DebouncedIn::get_pin()
 {
	 return(_pin);
 }
 
 
 void DebouncedIn::CheckState()
 {
	 static int Count = RELEASE_MSEC / CHECK_MSEC;
	 bool RawState = DebouncedIn::get_pin();
	 if(RawState==DebounceKeyPress)
	 {
		 if(DebounceKeyPress)
			Count = RELEASE_MSEC / CHECK_MSEC;
		 else
			Count = PRESS_MSEC / CHECK_MSEC; 
	 }
	 else
	 {
		 if(--Count == 0)
		 {
			 DebounceKeyPress = RawState;
			 if(DebounceKeyPress)
				Count = RELEASE_MSEC / CHECK_MSEC;
			 else
				Count = PRESS_MSEC / CHECK_MSEC; 
				 
		 }
	 }
	 
 }


 