#include "KXP84.h"

#define VERSION 0
#define REVISION 1

#ifdef _DEBUG
Serial debug(USBTX, USBRX); // tx, rx
#define dbg(FMT,...) debug.printf(FMT, ##__VA_ARGS__)
#else
#define dbg(...)
#endif

void tickproc();

KXP84_2050 kxp84(p11,p12,p13,p14,p10);  /* KXP84 compatible digital SPI input (PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst) */
/* SPI mode OUTPUT:
 * mbed     KXP84-2050        or AE-KXP84 module
 *  10 ------  8(RESET)           8(RESET)
 *  11 ------ 10(ADDRO/SDI)       9(ADDRO/SDI)
 *  12 ------ 11(SDA_SDO)         7(SDA_SDO)
 *  13 ------ 12(SCL/SCLK)        5(SCL/SCLK)
 *  14 ------  9(CS)             10(CS)
 */

//KXM52_1050 kxm52(p10,p15,p16,p17);    /* KXM52 compatible analog input (PinName power, PinName ix, PinName iy, PinName iz) */
/* ANALOG OUTOUT:
 * mbed     KXM52-1050(or KXP84-2050 analog output)
 *  10 ------  2(VDD)
 *  15 ------  5(X_OUT)
 *  16 ------  6(Y_OUT)
 *  17 ------  7(Z_OUT)
 */

int main() {
    dbg("\rKXP84-2050 Test Program %d.%03d\r\n", VERSION, REVISION);
    kxp84.Set_Risthner(tickproc);
    kxp84.Start();
}

void tickproc()
{
    dbg("%4X %4X %4X\r\n", kxp84.Get_X(), kxp84.Get_Y(), kxp84.Get_Z() );
}

