#include "mbed.h"

#define SAMPLES (26)
#define _DEBUG

namespace mbed {

class KXX
{
    typedef void (*func)(void);

    typedef struct {
        int    sample;
        int    buffer;
    } SamplingStruct;

    typedef struct {
        SamplingStruct x;
        SamplingStruct y;
        SamplingStruct z;
    } Sampling3DStruct;

    public:
        KXX();
        void                Start();
        virtual int         Get_X();
        virtual int         Get_Y();
        virtual int         Get_Z();
        void                Set_d( int x, int y, int z );
        void                Set_Risthner(func F){ risther = F; };

    private:
        virtual void        initial(){};
        void                tickProc();
        virtual void        funcTick(){};

    private:
        func                risther;
        Sampling3DStruct    d;
        Sampling3DStruct    gD[SAMPLES];
        int                 gT, gX, gY, gZ;
};

class KXP84_2050 : public KXX
{
    public:
        KXP84_2050(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst );

    private:
        SPI                 _spi;
        DigitalOut          _cs,_rst;
        virtual void        initial();
        virtual void        funcTick();
};

class KXM52_1050 :  public KXX
{
    public:
        KXM52_1050(PinName power, PinName ix, PinName iy, PinName iz);

    private:
        DigitalOut          _power;
        AnalogIn            _aiX, _aiY, _aiZ;
        virtual void        initial();
        virtual void        funcTick();
};

};
