#include "KXP84.h"
#include "mbed.h"

#define VERSION 0
#define REVISION 1

Ticker  t;

KXX::KXX()
{
    gT = 0;
    gX = 0;
    gY = 0;
    gZ = 0;
    risther = NULL;
}

void KXX::Set_d( int x, int y, int z )
{
    d.x.sample = x; d.x.buffer = 0;
    d.y.sample = y; d.y.buffer = 0;
    d.z.sample = z; d.z.buffer = 0;
}

int KXX::Get_X()
{
    return gX;
}

int KXX::Get_Y()
{
    return gY;
}

int KXX::Get_Z()
{
    return gZ;
}

void KXX::tickProc()
{
    int i;

    funcTick();
    // Average (radian sampling)
    if( SAMPLES<=gT ){
        gT = 0;
        gX = gD[SAMPLES/2].x.sample;
        gY = gD[SAMPLES/2].y.sample;
        gZ = gD[SAMPLES/2].z.sample;
        if(risther) risther();
    }

    for(i=0;i<gT;i++)
    {
        if ( gD[i].x.sample > d.x.sample ){
            gD[i].x.buffer ++;
        }else{
            d.x.buffer++;
        }
        if ( gD[i].y.sample > d.y.sample ){
            gD[i].y.buffer ++;
        }else{
            d.y.buffer++;
        }
        if ( gD[i].z.sample > d.z.sample ){
            gD[i].z.buffer ++;
        }else{
            d.z.buffer++;
        }
    }
    gD[i] = d;
    gT++;
}

void KXX::Start()
{
    initial();
    t.attach(this, &KXX::tickProc, 0.004); // 250Hz
}

void KXP84_2050::funcTick()
{
    int iX0,iX1;
    int iY0,iY1;
    int iZ0,iZ1;

    _cs = 0;            /* Select KXP84-2040 */
    _spi.write(0x80);   /* send Command */
    wait_us(200);       /* Wait 200us (for sampling) */

    iX0 = _spi.write(0x00); iX1 = _spi.write(0x00);  /* recive Status (with auto increment) */
    iY0 = _spi.write(0x00); iY1 = _spi.write(0x00);  /* recive Status (with auto increment) */
    iZ0 = _spi.write(0x00); iZ1 = _spi.write(0x00);  /* recive Status (with auto increment) */
    _cs = 1;            /* UnSelect KXP84-2040 */

    Set_d( (iX0<<8) + iX1, (iY0<<8) + iY1, (iZ0<<8) + iZ1 );
}

KXP84_2050::KXP84_2050(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst):
    _spi(mosi, miso, sclk), _cs(cs), _rst(rst)
{
    _rst = 1;
    _cs  = 1;
}

void KXP84_2050::initial()
{
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 2MHz clock rate
    _spi.format(8,1);
    _spi.frequency(2000000);

    _rst = 0;    /* WakeUp KXP84-2040 */
    wait_us(1);  /* wait > 130ns */

    _cs = 0;     /* Select KXP84-2040 */
    _spi.write(0x0A); _spi.write(0x00);
    _spi.write(0x0B); _spi.write(0x00);
    _cs = 1;    /* UnSelect KXP84-2040 */
    wait_us(1);  /* wait > 130ns */
}

void KXM52_1050::funcTick()
{
    Set_d( _aiX.read_u16(), _aiY.read_u16(), _aiZ.read_u16() );
}

KXM52_1050::KXM52_1050(PinName pwr, PinName ix, PinName iy, PinName iz):
    _power(pwr), _aiX(ix), _aiY(iy), _aiZ(iz)
{}

void KXM52_1050::initial()
{
    _power = 1;
}
