#ifndef THINGSPEAK_H
#define THINGSPEAK_H
#define HOSTNAME "mbed"
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

/** Class for sending data to ThingSpeak over ethernet,
 *  Class is using old mbed library revision and SensorsThingSpeak from
 *  https://developer.mbed.org/teams/TVZ-Mechatronics-Team/code/SensorsThingSpeak/
 * Example:
 * @code
 * #include "mbed.h"
 * #include "ThingSpeak.h"
 *
 * ThingSpeak thingSpeak("XXXXXXXXXXXXXXXX");
 *
 * int main() {
 *     int i = 1;
 *     flot value = 3.14;
 *     thingSpeak.connect();
 *     thingSpeak.setField(value,i)
 *     thingSpeak.putUp();
 * }
 * @endcode
*/
class ThingSpeak
{

public:
    /** Write api key provided from ThingSpek channel.
     * @param: write api key provided from ThingSpeak channel.
    */
    ThingSpeak(char*);
    /**
     * Establishing ethernet connection until connected.
     *
    */
    void connect();
    
    /**
    *   Funkcion for pulling data from ThingSpeak.
    *   @param readKey Channel feed number
    *   @param Field number.
    */
    float pull(long int, int);
    
    
    void putUp();
    /**
     *Setting values to the field, they should be set in order.
     * It's not required to set them all  (example: you can set 1, 2, 3 or 1, 3)
     * @param Field value to store on.
     * @param i number of a field.
    */
    void setField(float field, int i);
private:

    char* thingSpeakUrl;
    char* thingSpeakRead;
    char* thingSpeakKey;
    char urlBuffer[1023];
    char fieldBuffer[1023];
    EthernetNetIf eth;
    EthernetErr ethErr;
    HTTPClient http;
    IpAddr ethIp;
    HTTPText resp;
    HTTPResult res;
};

#endif