#include "mbed.h"
#include "ThingSpeak.h"
#include "TextLCD.h"
#include "DustSenzor.h"

ThingSpeak ts("FI2NZGSOB8LSR8YX"); 
DustSenzor ds(p5, p9, p10); // set pin, uartTx pin, Rx pin
float value[6];
float finValue[3];
TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD16x2);

int main() {
    float *ptr;
    ts.connect();
    wait(1);
    while(1){     
        float res = ts.pull(282724, 1);
        if(res == 1){
            ds.start();
            }
        while( res == 1){
                ptr = ds.read();
                
                    for( int i = 0; i < 6; i++) 
                        value[i] = *(ptr + i);
                
                finValue[0] = ( value[0] - value[2] ); // 0.3 - 1 um / m3
                finValue[1] = ( value[2] - value[4] ); // 1 - 5 um / m3
                finValue[2] = ( value[4] - value[5] ); // 5 - 10 um / m3
                    
                    for ( int j = 0; j < 3; j++ ) 
                        ts.setField( finValue[j], j+1);
                            
                ts.putUp();
                wait(15);
                res = ts.pull(282724, 1);
            }
        ds.stop();           
    }
}
        
