#include "mbed.h"
#include "DustSenzor.h"


DustSenzor :: DustSenzor ( PinName set, PinName uartTx, PinName uartRx ) : set( set ), uart( uartTx, uartRx ) {
    this -> set = 0;
    uart.baud(9600); 
    uart.format(8,Serial::None,1);
    uart.attach(this, &DustSenzor::serialRead, Serial::RxIrq); 
    br = 0;
}


void DustSenzor::start() {
     this -> set = 1;
    
}

void DustSenzor::stop() {
   this -> set = 0;
}
   
float * DustSenzor::read() {
    float* ptr = new float[6];
    for(int i = 0; i < 6; i++) 
        ptr[i] = value[i];
    return ptr;
}

void DustSenzor::readBuffer() {
    if(buff[0] == 0x42 ){
        if(buff[1] == 0x4d) { 
            save(buff);    
            br = 0;
            }
        }
}


void DustSenzor::serialRead() {
    buff[br]=uart.getc();
    br++; 
    if(br == 32){ 
        readBuffer();
        }
} 

    

void DustSenzor::save( unsigned char *thebuff) {
    int j = 16;
    for(int i = 0; i < 6; i++) {
       value[i] =  thebuff[j+1]|thebuff[j]<<8;     
       j += 2;  
    }   
}

/*  
    * thebuff[17]|thebuff[16]<<8;    number of particles with diameter beyond 0.3 um in 0.1 L of air. 
    * thebuff[19]|thebuff[18]<<8;    number of particles with diameter beyond 0.5 um in 0.1 L of air. 
    * thebuff[21]|thebuff[20]<<8;    number of particles with diameter beyond 1.0 um in 0.1 L of air. 
    
    * thebuff[23]|thebuff[22]<<8;    number of particles with diameter beyond 2.5 um in 0.1 L of air.  
    * thebuff[25]|thebuff[24]<<8;    number of particles with diameter beyond 5 um in 0.1 L of air. 
    * thebuff[27]|thebuff[26]<<8;    number of particles with diameter beyond 10 um in 0.1 L of air. 
*/