#ifndef DUSTSENZOR_H
#define DUSTSENZOR_H
#include"mbed.h"

   /** Simple class for reading values from Plantower PMS5003 dust concentration sensor.
    *
    * Example:
    * @code:
    * #include "mbed.h"
    * #include "DustSenzor.h"
    
    * DustSenzor ds(p5, p9, p10);
    * float values [6];
    * float *ptr;
    *
    * int main() {
    *   ds.start();
    *   ptr = ds.read();
    *    
    *       for( int i = 0; i < 6; i++) {
    *           values [i] = *(ptr + i);
    *           }
    *   }
    * @endcode
    */
class DustSenzor {
    
    public:
        /** Create DustSenzor instance.
         *  @param set Sensor set pin.
         *  @param uartTx Sensor Tx pin.
         *  @param uartRx Sensor Rx pin.
         */
        DustSenzor ( PinName set, PinName uartTx, PinName uartRx );
        
        /** Start the communication with sensor.
        */
        void start();
        
        /** Stop the communication with sensor.
        */
        void stop();
        
        /** Read the values from a float array with 6 elements. 
         *   Function is returnig a pointer to the first element of array.
        */
        float* read();
          
    private:
        float value[6];
        Serial uart;
        DigitalOut set;
        unsigned char buff[32];
        bool provjera;
        int br;
        void serialRead();
        void readBuffer();
        void save( unsigned char *);
       
};
#endif
    

