
#include "mbed.h"
#include "SprintUSBModem.h"
#include "HTTPClient.h"
#include "Websocket.h"

void websocketTest(void const*) 
{
    SprintUSBModem modem(p18, true, 1);
    char msg[2048] = {0};
    
    // Using C16-C20 make sure to connect mbed p18 to J2 pin 16
    modem.power(true);
    int ret = modem.connect();
    if(ret)
    {
        error("Modem connect failed: %s line %d", __PRETTY_FUNCTION__ , __LINE__);
    }
    
    // See the output on http://sockets.mbed.org/sg_test/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/sg_test/rw");
    ws.connect();
    for(int i=0; i<0x7fffffff; ++i)
    {
        // create json string with acc/tmp data
        sprintf(msg, "Testing mbed Websockets Loop: %d", i);
        ws.send(msg);    
        wait(0.5f);
        memset(msg, 0, 2048);
        
        if (ws.read(msg))
        {
            printf("rcv: %s\r\n", msg);
        }
        else
        {
            printf("Loop %d ws.read() returns 0\n", i);
        }
    }
    
    ws.close();
    
    modem.disconnect();
    modem.power(false); 
    
    puts("Powered off Test Complete");
    while(1);
}

void httpTest(void const*) 
{
    SprintUSBModem modem(p18, true, 1);
    char const *URL_GET = "http://mbed.org/media/uploads/donatien/hello.txt";
    char const *URL_POST = "http://httpbin.org/post";
    char msg[2048] = {0};
    char buf[32] = {0};
    
    // Using C16-C20 make sure to connect mbed p18 to J2 pin 16
    modem.power(true);
    int ret = modem.connect();
    if(ret)
    {
        error("Modem connect failed: %s %d", __PRETTY_FUNCTION__ , __LINE__);
    }
    
    HTTPClient  http;
    HTTPMap     map;
    HTTPText    text(msg, 512);
    
    for(int i=0; i<0x7fffffff; ++i)
    {
        //GET data
        ret = http.get(URL_GET, msg, 2048);
        if (!ret)
        {
            printf("%s\n", msg);
        }
        else
        {
            printf("%s\n", msg);
            error("http.get() = %d \t HTTP return code = %d \t %s, line %d\n", ret, http.getHTTPResponseCode(), __PRETTY_FUNCTION__, __LINE__);
        }
        
        sprintf(buf, "%d", i);
        map.put("Loop count", buf);
        map.put("mbed", "connect");
        
        //POST data
        ret = http.post(URL_POST, map, &text);
        if (0 == ret)
        {
            printf("%s\n", msg);
        }
        else
        {
            error("http.post() = %d \t HTTP return code = %d \t %s, line %d\n", ret, http.getHTTPResponseCode(), __PRETTY_FUNCTION__, __LINE__);
        }
        map.clear();
        memset(msg, 0, 2048);
    }
    
    modem.disconnect();  
    modem.power(false); 
    
    puts("Powered off Test Complete");
    while(1);
}

int main()
{

//    Thread task(websocketTest, NULL, osPriorityNormal, 1024 * 5);
    Thread task(httpTest, NULL, osPriorityNormal, 1024 * 5);
    
    DigitalOut led(LED1);
    
    while(1)
    {
        led = !led;
        Thread::wait(1000);  
    }
    
    return 0;
}
