#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

//mbed Application board waveplayer demo
//Plays the wave file "sample.wav" on the SD drive
//Outputs to p18 analogue out to an audio amp and speaker 

 
//Analog Out Jack
AnalogOut DACout(p18);
//On Board Speaker
PwmOut PWMout(p26);

//SD card
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

wave_player waver(&DACout,&PWMout);

int main()
{
   char buffer[20];
    FILE *wave_file;
    //setup PWM hardware for a Class D style audio output
    PWMout.period(1.0/400000.0);
  while(1){
    led1=1;
    led2=0;
    led3=1;
    led4=0;
     
    for (int a=1;a<40; a++){
    sprintf(buffer,"/sd/voice%d.wav",a);    
    wave_file=fopen(buffer,"r");
    waver.play(wave_file);
    fclose(wave_file);
    if (a%2!=0){
    led1= !led1;
    led2= !led2;
    led3= !led3;
    led4= !led4;
     }
    }
    
  }
}