/**************************************************************************************/
/**************************************************************************************/
/*SMARTGPU2 intelligent embedded graphics processor unit
 those examples are for using the SMARTGPU2 with the mbed microcontoller, just connect tx,rx,and reset
 Board:
 http://www.vizictechnologies.com/
 
 www.vizictechnologies.com 
 Vizic Technologies copyright 2014 */
/**************************************************************************************/
/**************************************************************************************/

#include "mbed.h"
#include "SMARTGPU2.h"

AnalogIn hrm (p16);
DigitalIn DigHRM (p21);
AnalogIn gsr(p17); // alalogue input pin for the galvanic skin response sensor

Serial pc(USBTX, USBRX); // pc's usb tx, rx

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);

SMARTGPU2 lcd(TXPIN,RXPIN,RESETPIN);  //create our object called "lcd"

TIME timeRTC;
STATE stateRTC;
/***************************************************/
/***************************************************/
void initializeSmartGPU2(void){      //Initialize SMARTGPU2 Board
  lcd.reset();                       //physically reset SMARTGPU2
  lcd.start();                       //initialize the SMARTGPU2 processor
}
 
float gsrValue = 0,gsrbaseline = 0,hrmValue = 0,hrmbaseline = 0;

void Get_gsrBaseline(void)
{
    double gsrsum = 0;
    wait(1);
    for(int i=0; i<500; i++) {
        gsrValue = gsr;
        gsrsum += gsrValue;
        wait(0.005);
    }
    gsrbaseline = gsrsum/500;
}

// calculate hrmbaseline to compare against
void Get_hrmBaseline(void)
{
    double hrmsum = 0;
    wait(1);
    for(int i=0; i<500; i++) {
        hrmValue = hrm;
        hrmsum += hrmValue;
        wait(0.005);
    }
    hrmbaseline = hrmsum/500;
}

FILERESULT fres;            //create the variable that will store all SMARTGPU2 commands responses
int sdok;

unsigned int row=10;

//function that checks if the SD card operation had a problem
void die(unsigned char response){ //if the response is different than OK, print and wait for 3 seconds
  NUMBEROFBYTES charsPrint;
  pc.printf("%d\r\n",response);  //write to the USB PC if there is a problem
  if(response!=F_OK){
    pc.printf("Error on microSD... \r\n");
    wait(3);
 //   while(1);  
    }
    sdok=1;
}


int main() { //start of main program ********

  SMARTGPUREPLY res; // responses from GPU
  POINT point;

  int but1; // button pressed variable
  pc.baud(9600);
  
  initializeSmartGPU2();             //Init communication with SmartGPU2 board
  
  lcd.baudChange(BAUD6);             //set a fast baud! for fast drawing

  res = lcd.setupRTC(&stateRTC); // start the SmartGPU2 Real Time Clock RTC
  
  NUMBEROFBYTES bytes; // for use in text string call

  float gsrValue = 0,gsrbaseline = 0,aHRMvalue = 0,dHRMvalue = 0;

  while(1)
  {        // set up a loop to keep endless operation and changes to user operation
  pc.printf("Start of Main\r\n");
   but1 = 0;  
   gsrbaseline = gsr;
   lcd.erase();
   lcd.setTextColour(WHITE);
   lcd.setTextSize(FONT1); 

  //draw the object button1 and button2
  lcd.objButton(10, 170, 150, 220, DESELECTED, "Change?");
  lcd.objButton(170, 170, 309, 220, DESELECTED, "Continue");     
  
  res = lcd.getRTCTimeDate(&timeRTC);
  lcd.string(70,40,300,60,"Hour Minutes Seconds", &bytes);
  lcd.string(0,60,69,80,"Time:", &bytes);
  lcd.string(70,100,300,120,"Day  Month  Year", &bytes); 
  lcd.string(0,120,100,140,"Date:", &bytes);

    lcd.printNumber(85,60, timeRTC.hour); 
    lcd.printNumber(130,60, timeRTC.minute); 
    lcd.printNumber(190,60, timeRTC.second);
    lcd.printNumber(85,120, timeRTC.day);  
    lcd.printNumber(130,120, timeRTC.month); 
    lcd.printNumber(190,120, timeRTC.year);

lcd.setTextColour(GREEN);
lcd.string(0,0,300,20,"Press Change? to set the time", &bytes);     
lcd.setTextColour(WHITE);
pc.printf("TEST\r\n");//debug   
but1=0; // prepare for catching a button press 
led_2=0; //debug
 while (but1 == 0) //wait for button press loop
 {
         //ask for a touch
    if(lcd.touchScreen(&point)==VALID)
      { //if a touch on screen is valid check which button        
      if(point.y>170 && point.y<220 && point.x<160) 
        { //if the touch on button1 draw the object button1 as SELECTED
        lcd.objButton(10, 170, 150, 220, SELECTED, "Change Time?");
        wait_ms(50);
        lcd.objButton(10, 170, 150, 220, DESELECTED, "Change Time?");
    pc.printf("change time button pressed\r\n"); //debug
    timeRTC.hour = 18; // SET DATE AND TIME VALUES HERE ONCE
    timeRTC.minute = 55;
    timeRTC.second = 0;
    timeRTC.day = 7;
    timeRTC.month = 1;
    timeRTC.year = 2018;
    res = lcd.setRTCTimeDate(&timeRTC); // send the above values to the RTC
         wait(2);
         res = lcd.getRTCTimeDate(&timeRTC); // get the RTC values back
         lcd.setTextColour(WHITE);
         lcd.drawRectangle(200, 0, 318, 20, BLACK, FILL); // date refresh
         lcd.drawRectangle(85, 60, 300, 80, BLACK, FILL); //time refresh 
         lcd.drawRectangle(85, 120, 300, 140, BLACK, FILL); //clears the area of screen with numbers so not to overwrite causing blurred numbers
         lcd.printNumber(85,60, timeRTC.hour); 
         lcd.printNumber(130,60, timeRTC.minute); 
         lcd.printNumber(190,60, timeRTC.second);
         lcd.printNumber(85,120, timeRTC.day); 
         lcd.printNumber(130,120, timeRTC.month); 
         lcd.printNumber(190,120, timeRTC.year);
         lcd.drawRectangle(0, 0, 300, 20, BLACK, FILL); // date refresh
         lcd.string(0,0,300,20,"OK new time set from storred values", &bytes); 
         wait(3);// display for 2 seconds
         led_2=1;  
         but1 = 1; // button was pressed so set var to get out of this button press loop
         } //end of Button 1 pressed IF 
      
      //IF BUTTON2        
      if(point.y>170 && point.y<220 && point.x>160)
        { //if the touch on button2 draw the object button2 as SELECTED
        lcd.objButton(170, 170, 309, 220, SELECTED, "Continue");
        wait_ms(50);
        lcd.objButton(170, 170, 309, 220, DESELECTED, "Continue");
        but1 = 1;// button was pressed so set var to get out of thi sbutton press loop
        pc.printf("continue button pressed\r\n");   //debug
        }//end of Button 2 pressed IF 
      } // end of has a valid screen touch been made IF 
   } //end of second wait for button press while statement

but1=0; //reset button pressed var
int candidate=0; //set up a var to track which candidate to be monitored
lcd.erase(); //clear the screen
lcd.setTextColour(WHITE);
 
//draw the object button1 through button4 for Candidate selection
lcd.string(0,0,300,20,"Select the Candidate to be monitored", &bytes);
lcd.objButton(10, 30, 200, 60, DESELECTED, "Candidate 1");
lcd.objButton(10, 85, 200, 120, DESELECTED, "Candidate 2");
lcd.objButton(10, 145, 200, 180, DESELECTED, "Candidate 3");
lcd.objButton(10, 205, 200, 238, DESELECTED, "Candidate 4");

while (but1 == 0) //wait for button press loop
  {
         //pc.printf("endless time loop\r\n");   //debug
         led_4=!led_4; //debug   
          if(lcd.touchScreen(&point)==VALID)
           { //if a touch on screen is valid check which button        
           if(point.y>30 && point.y<60 && point.x<200) 
             { //if the touch on button1 draw the object button1 as SELECTED
             lcd.objButton(10, 30, 200, 60, SELECTED, "Candidate 1");
             wait_ms(50);
             lcd.objButton(10, 30, 200, 60, DESELECTED, "Candidate 1");
             pc.printf("Candidate 1\r\n"); //debug
             but1=1;
             candidate=1;
             }// end of if button 1 pressed
           
           if(point.y>85 && point.y<120 && point.x<200) 
             { //if the touch on button1 draw the object button1 as SELECTED
             lcd.objButton(10, 85, 200, 120, SELECTED, "Candidate 2");
             wait_ms(50);
             lcd.objButton(10, 85, 200, 120, DESELECTED, "Candidate 2");
             pc.printf("Candidate 2\r\n"); //debug
             but1=1;
             candidate=2;
             }// end of if button 2 pressed
             
            if(point.y>145 && point.y<180 && point.x<200) 
             { //if the touch on button1 draw the object button1 as SELECTED
             lcd.objButton(10, 145, 200, 180, SELECTED, "Candidate 3");
             wait_ms(50);
             lcd.objButton(10, 145, 200, 180, DESELECTED, "Candidate 3");
             pc.printf("Candidate  3\r\n"); //debug
             but1=1;
             candidate=3;
             }// end of if button 3 pressed
           
            if(point.y>205 && point.y<238 && point.x<200) 
             { //if the touch on button1 draw the object button1 as SELECTED
             lcd.objButton(10, 205, 200, 238, SELECTED, "Candidate 4");
             wait_ms(50);
             lcd.objButton(10, 205, 200, 238, DESELECTED, "Candidate 4");
             pc.printf("Candidate 4\r\n"); //debug
             but1=1;
             candidate=4;
             }// end of if button 4 pressed
           }// end of if screen touched
} //end of the button press while

wait(1);
lcd.erase(); //clear the screen
lcd.setTextColour(CYAN);  
lcd.setTextSize(FONT1);
if (candidate==0)lcd.string(0,0,300,20,"NO Candidate selected", &bytes);
if (candidate==1)lcd.string(0,0,300,20,"Candidate 1 selected", &bytes);
if (candidate==2)lcd.string(0,0,300,20,"Candidate 2 selected", &bytes);
if (candidate==3)lcd.string(0,0,300,20,"Candidate 3 selected", &bytes);
if (candidate==4)lcd.string(0,0,300,20,"Candidate 4 selected", &bytes);
wait(1);
sdok=0;

  char buffer[100]={0}; 
  unsigned int dirs=0, files=0, i=0, sdcardavail=0;
  NUMBEROFBYTES charsPrinted;

  unsigned char response;    

  fres=lcd.SDFgetList(&dirs,&files);    //obtain dirs and files
  die(fres);
   if(sdok==1)
    {//if the SD card is there and ok list the directory contents
    pc.printf("SD card is there\r\n");
    sdcardavail=1; // set to determine if user given choice to save session to SD card    
    } //end of if statement to check if SD disc there and ok 
wait(1);

int storetosd=0; //set up a var to track if seesion to be saved to disc if so at what intervals

if(sdcardavail==1)
  {  //only give these options if a SD card is available and ok
  but1=0; //reset button pressed var
  lcd.erase(); //clear the screen
  lcd.setTextColour(WHITE);
  //draw the object button1 through button4 for save to disc option selection
  lcd.string(0,0,315,20,"Select if session to be saved to disc, if so, select interval required", &bytes);
  lcd.objButton(10, 30, 200, 60, DESELECTED, "Don't Save");
  lcd.objButton(10, 85, 200, 120, DESELECTED, "Save, 1 minute");
  lcd.objButton(10, 145, 200, 180, DESELECTED, "Save, 15 minutes");
  lcd.objButton(10, 205, 200, 238, DESELECTED, "Save, 30 minutes");

  while(but1 == 0) //wait for button press loop
       {
       //pc.printf("endless time loop\r\n");   //debug
       led_4=!led_4; //debug   
       if(lcd.touchScreen(&point)==VALID)
         { //if a touch on screen is valid check which button        
         if(point.y>30 && point.y<60 && point.x<200) 
           { //if the touch on button1 draw the object button1 as SELECTED
           lcd.objButton(10, 30, 200, 60, SELECTED, "Don't Save");
           wait_ms(50);
           lcd.objButton(10, 30, 200, 60, DESELECTED, "Don't Save");
           pc.printf("Don't Save\r\n"); //debug
           but1=1;
           storetosd=1;
           }// end of if button 1 pressed
           
         if(point.y>85 && point.y<120 && point.x<200) 
           { //if the touch on button1 draw the object button1 as SELECTED
           lcd.objButton(10, 85, 200, 120, SELECTED, "Save, 1 minute");
           wait_ms(50);
           lcd.objButton(10, 85, 200, 120, DESELECTED, "Save, 1 minute");
           pc.printf("Save 1 minute\r\n"); //debug
           but1=1;
           storetosd=2;
           }// end of if button 2 pressed
             
         if(point.y>145 && point.y<180 && point.x<200) 
           { //if the touch on button1 draw the object button1 as SELECTED
           lcd.objButton(10, 145, 200, 180, SELECTED, "Save, 15 minutes");
           wait_ms(50);
           lcd.objButton(10, 145, 200, 180, DESELECTED, "Save, 15 minutes");
           pc.printf("Save, 15 minutes\r\n"); //debug
           but1=1;
           storetosd=3;
           }// end of if button 3 pressed
           
         if(point.y>205 && point.y<238 && point.x<200) 
           { //if the touch on button1 draw the object button1 as SELECTED
           lcd.objButton(10, 205, 200, 238, SELECTED, "Save, 30 minutes");
           wait_ms(50);
           lcd.objButton(10, 205, 200, 238, DESELECTED, "Save, 30 minutes");
           pc.printf("Save, 30 minutes\r\n"); //debug
           but1=1;
           storetosd=4;
           }// end of if button 4 pressed
         }// end of if screen touched
       } //end of the button press while
   }//end of if SD card available statement

//wait(3);
lcd.erase(); //clear the screen
lcd.setTextColour(CYAN);  
lcd.setTextSize(FONT1);
if (storetosd==1)lcd.string(0,0,300,20,"Don't Save", &bytes);
if (storetosd==2)lcd.string(0,0,300,20,"1 minute selected", &bytes);
if (storetosd==3)lcd.string(0,0,300,20,"15 minutes selected", &bytes);
if (storetosd==4)lcd.string(0,0,300,20,"30 minutes selected", &bytes);
if (storetosd==0)lcd.string(0,0,300,20,"nothing selected", &bytes);
//wait(5);




 lcd.erase();  
 lcd.setTextColour(GREEN);
if (candidate==0)lcd.string(0,0,150,20,"NO Candidate selected", &bytes);
if (candidate==1)lcd.string(0,0,150,20,"Candidate 1", &bytes);
if (candidate==2)lcd.string(0,0,150,20,"Candidate 2", &bytes);
if (candidate==3)lcd.string(0,0,150,20,"Candidate 3", &bytes);
if (candidate==4)lcd.string(0,0,150,20,"Candidate 4", &bytes);

 lcd.setTextColour(WHITE);
 lcd.string(80,220,310,238,"   HRM     GSR",&bytes);

 lcd.string(0,60,100,80,"GSR Baseline", &bytes);  //write a string on the screen
 lcd.string(0,81,100,100,"GSR Analogue In", &bytes);  //write a string on the screen
 lcd.string(0,101,100,120,"HRM Analogue In", &bytes);  //write a string on the screen
 lcd.string(0,121,100,150,"HRM Digital In", &bytes);  //write a string on the screen

float gsrdelta,gsrdeltaabs,hrmdeltaabs,hrmdelta,gsr1, gsr2, gsr3, hrm1, hrm2, hrm3;

 Get_gsrBaseline();
 Get_hrmBaseline();

     gsr1 = (gsrbaseline+(0.05 * gsrbaseline)); //level 1 GSR Top boundry 5% 
     gsr2 = (gsrbaseline+(0.10 * gsrbaseline)); //level 2 GSR Top boundry 10%   
     gsr3 = (gsrbaseline+(0.15 * gsrbaseline)); //level 3 GSR Top boundry 15%  
     hrm1 = (hrmbaseline+(0.25 * hrmbaseline)); //level 1 HRM Top boundry 25% 
     hrm2 = (hrmbaseline+(0.50 * hrmbaseline)); //level 2 HRM Top boundry 50%   
     hrm3 = (hrmbaseline+(0.75 * hrmbaseline)); //level 3 HRM Top boundry 75% 
int d=0;
but1=0;
lcd.setTextColour(WHITE);
 //draw the object button1 Exit
unsigned int writtenBytes=0;   

  if(storetosd>1 && storetosd<5)
      {                         //open a file on the SD card called log.txt
      pc.printf("Try to open a file on the SD card called log.txt\r\n");
      //try to open the file
      fres=lcd.SDFopenFile("log.txt", WRITEONLY, WORKSPACE0);  //Try to open the file in write only mode in the workspace block 0    
      if(fres!=F_OK){                       //If the file doesn't Open is because it doesn't exist      
        pc.printf("File doesn't exist, creating log.txt file...\r\n");    
        fres=lcd.SDFnewFile("log.txt");  //Try to create the file 
        die(fres);                        //If any error report it
        fres=lcd.SDFopenFile("log.txt", WRITEONLY, WORKSPACE0);  //Try to open the created file      
        die(fres);                        //If any error report it
        }
      char messagetitle[100]="Candidate, Interval , GSR Base ,  GSR  ,  HRM  ,  Day  ,  Month , Hour , Minute , Second \n"; 

      res = lcd.getRTCTimeDate(&timeRTC); // get the RTC values back
      lcd.SDFsetFileTimeDate(&timeRTC, "log.txt"); //Set Time and Date to the now existing log.txt file
      pc.printf("***********saving titles to file \r\n");
      writtenBytes=0; //, readbytes=0; //i=0; 
      fres=lcd.SDFwriteFile(messagetitle, sizeof(messagetitle), &writtenBytes, WORKSPACE0); //write to the open file in WORKSPACE0 size of message in bytes and store the successfully written Bytes on writtenBytes variable
      die(fres);                         //If any error report it    
      lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
      }      
      
char textStringgsr[9],textStringgsrb[9],textStringhrm[9],textday[3],textmonth[3],texthour[3],textminute[3],textsecond[3]; //textStringhrmb[9] if baseline achieved later
int length,k=0,j=0,l=0,z=0;




lcd.objButton(10, 180, 50, 215, DESELECTED, "EXIT"); // draw the object button to provide exit 

while (but1 == 0) //wait for button press loop
  {

    gsrValue = gsr;
    aHRMvalue = hrm;
    dHRMvalue = DigHRM;
   // wait(1);
    lcd.setTextColour(WHITE);
    lcd.printNumber(110,60, gsrbaseline); 
    lcd.printNumber(110,81, gsrValue); 
    lcd.printNumber(110,101, aHRMvalue);
    lcd.printNumber(110,121, dHRMvalue);
         res = lcd.getRTCTimeDate(&timeRTC); // get the RTC values back
         lcd.setTextColour(WHITE);
         lcd.string(0,21,318,40,"Time:", &bytes);
         lcd.printNumber(70,21, timeRTC.hour); // write them to the TFT
         lcd.printNumber(95,21, timeRTC.minute); 
      //   lcd.printNumber(170,21, timeRTC.second);
         lcd.printNumber(200,0, timeRTC.day); 
         lcd.printNumber(230,0, timeRTC.month); 
         lcd.printNumber(260,0, timeRTC.year);        
    
        gsrValue = gsr; //put actual gsr pin input into a variable
        gsrdelta = gsrbaseline - gsrValue;
        gsrdeltaabs = abs(gsrdelta);
        if (gsrdeltaabs < gsrbaseline)
           {
            gsrdeltaabs = gsrbaseline + gsrdeltaabs; // make all negative values regarding baseline +ve
           } 
        if((gsrdeltaabs >= gsrbaseline) && (gsrdeltaabs <= gsr1))  // check for being upto 5% of baseline
           {   
           lcd.drawRectangle(100, 180, 140, 215, GREEN, FILL);
           // x, y, width, height, colour
           }
        if((gsrdeltaabs > gsr1) && (gsrdeltaabs <= gsr2))  // check for being > 6% to 10% of baseline
           {   
             lcd.drawRectangle(100, 180, 140, 215, YELLOW, FILL);
             //x, y, width, height, colour
           }
        if((gsrdeltaabs > gsr2) && (gsrdeltaabs <= gsr3))  // check for being > 11% to 15% of baseline
           { 
             lcd.drawRectangle(100, 180, 140, 215, CYAN, FILL);  
             //x, y, width, height, colour
           }
        if(gsrdeltaabs > gsr3)  // check for being > 16% of baseline
           { 
             lcd.drawRectangle(100, 180, 140, 215, RED, FILL);  
             //x, y, width, height, colour
           }
           
        hrmValue = hrm; //Heart Rate Monitor
        //printf("hrmValue = %f\n\r",hrmValue);
        hrmdelta = hrmbaseline - hrmValue;
        hrmdeltaabs = abs(hrmdelta);
       if (hrmdeltaabs < hrmbaseline)
           {
            hrmdeltaabs = hrmbaseline + hrmdeltaabs; // make all negative values regarding baseline +ve
           } 
        if((hrmdeltaabs >= hrmbaseline) && (hrmdeltaabs <= hrm1))  // check for being > 1% to 25% of baseline
           {   
             lcd.drawRectangle(180, 180, 220, 215, GREEN, FILL);
             //x, y, width, height, colour
           }
        if((hrmdeltaabs > hrm1) && (hrmdeltaabs <= hrm2))  // check for being > 26% to 50% of baseline
           {   
             lcd.drawRectangle(180, 180, 220, 215, YELLOW, FILL);
             //x, y, width, height, colour
           }
        if((hrmdeltaabs > hrm2) && (hrmdeltaabs <= hrm3))  // check for being > 51% to 75% of baseline
           { 
             lcd.drawRectangle(180, 180, 220, 215, CYAN, FILL);  
           }
        if(hrmdeltaabs > hrm3)  // check for being > 76% of baseline
           { 
             lcd.drawRectangle(180, 180, 220, 215, RED, FILL);  
            }
    
  
    wait(0.5);
    lcd.setTextColour(BLACK);
    lcd.drawRectangle(200, 0, 318, 20, BLACK, FILL); // date refresh
    lcd.drawRectangle(70, 21, 300, 60, BLACK, FILL); //time refresh 
    lcd.drawRectangle(101, 31, 300, 100, BLACK, FILL); //clears the area of screen with numbers so not to overwrite causing blurred numbers
    lcd.printNumber(110,60, gsrbaseline); 
    lcd.printNumber(110,81, gsrValue); 
    lcd.printNumber(110,101, aHRMvalue);
    lcd.printNumber(110,121, dHRMvalue);
    
    if(storetosd>1 && storetosd<5)
      {  //if data to be captured to sd card do the following
       res = lcd.getRTCTimeDate(&timeRTC);
       length=snprintf(textday,3,"%d",timeRTC.day);
       length=snprintf(textmonth,3,"%d",timeRTC.month);
       length=snprintf(texthour,3,"%d",timeRTC.hour);
       length=snprintf(textminute,3,"%d",timeRTC.minute);
       length=snprintf(textsecond,3,"%d",timeRTC.second);
       length=snprintf(textStringgsrb,9,"%f",gsrbaseline);// convert gsr baseline float to character string to send to SD card
       length=snprintf(textStringgsr,9,"%f",gsrValue);// convert gsr float to character string to send to SD card
       length=snprintf(textStringhrm,9,"%f",aHRMvalue);// convert analogue hrm float to character string to send to SD card
       
       // length=snprintf(textStringgsr,9,"%f",gsrValue);// convert float to character string to send to SD card
       char messageft[60]="\0";
       if (candidate <1 || candidate>4) {strcat(messageft,"0,");}
       if (candidate==1) {strcat(messageft,"1,");}
       if (candidate==2) {strcat(messageft,"2,");}
       if (candidate==3) {strcat(messageft,"3,");}
       if (candidate==4) {strcat(messageft,"4,");}
       if (storetosd==2) {strcat(messageft,"1,");}
       if (storetosd==3) {strcat(messageft,"15,");}
       if (storetosd==4) {strcat(messageft,"30,");}
       strcat(messageft,textStringgsrb);
       strcat(messageft,",");
       strcat(messageft,textStringgsr);
       strcat(messageft,",");
       strcat(messageft,textStringhrm);
       strcat(messageft,",");
       strcat(messageft,textday);// add the hour value
       strcat(messageft,",");
       strcat(messageft,textmonth);// add the hour value
       strcat(messageft,",");
       strcat(messageft,texthour);// add the hour value
       strcat(messageft,",");
       strcat(messageft,textminute);// add the minute value
       strcat(messageft,",");
       strcat(messageft,textsecond);// add the hour value
       strcat(messageft,"\n");
       pc.printf("%s\r\n",messageft);
       
          lcd.setTextColour(WHITE);//recording notice on screen
          lcd.string(15,220,70,238,"Rec", &bytes);
          wait(0.1);
  
      if(storetosd==2)
        {             //if data to be captured to sd card every 1 minute do the following  
        if(k==0)
          {// if timer hasnt been started start it
          k=1; // start timer once per selected period 
          j=timeRTC.second;// store second value
          timeRTC.second++; //move the timer forward by one to prevent chance of immediate trigger of timer trap  
          pc.printf("***********************start 1 min timer\r\n");
          }
        if(timeRTC.second!=j)
          {  //if second value is different from previous value assue 1 second has expired
          //k=0;
          j=timeRTC.second;// store new second value
          l++; //increment second timer
          pc.printf("************************** %d seconds have elapsed\r\n",l);
          if (l==60)
             {  // 60 seconds have elapsed so lets save data to the SD card
             l=0; //reset 1 minute counter
             k=0; //reset timer
             lcd.setTextColour(RED);
             lcd.string(15,220,70,238,"Rec", &bytes);
             wait(1);
             pc.printf("***********reset 1 min timer\r\n");
             pc.printf("***********saving to file - 1 minute\r\n");
             writtenBytes=0; //, readbytes=0; //i=0; 
             fres=lcd.SDFwriteFile(messageft, sizeof(messageft), &writtenBytes, WORKSPACE0); //write to the open file in WORKSPACE0 size of message in bytes and store the successfully written Bytes on writtenBytes variable
             die(fres);                         //If any error report it    
             lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
             }
          } 
        }
        
      if(storetosd==3)
        {             //if data to be captured to sd card every 15 minutes do the following  
        if(k==0)
          {// if timer hasnt been started start it
          k=1; // start timer once per selected period 
          j=timeRTC.minute;// store initial minute value
          l=0; //clear minute counter
          }
        if(k==1)
          {   //if timer started do the following
             //z=j; // save last value for minute  
          if(timeRTC.minute==j)
            { //the minute value has not changed
            z=0;
            }
            else
            {   //if the minute value has changed
            l++; // count how many minutes have passed
            j=timeRTC.minute;// store new minute value
            pc.printf("*************************** %d minutes have elapsed\r\n",l);
            }  
          if(l==15)
            {  // 15 minutes have elapsed so lets save data to the SD card
            l=0; //reset 15 minute counter
            k=0; //reset timer
            lcd.setTextColour(RED);
            lcd.string(15,220,70,238,"Rec", &bytes);
            wait(1);
            pc.printf("***********reset 15 min timer\r\n");
            pc.printf("***********saving to file - 15 minute\r\n");
            writtenBytes=0; //, readbytes=0; //i=0; 
            fres=lcd.SDFwriteFile(messageft, sizeof(messageft), &writtenBytes, WORKSPACE0); //write to the open file in WORKSPACE0 size of message in bytes and store the successfully written Bytes on writtenBytes variable
            die(fres);                         //If any error report it    
            lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
            } //end of if 15 mins counted
          } //end of if timer has started
         }  // end of if 15min capture time selected
 
 
      if(storetosd==4)
        {             //if data to be captured to sd card every 15 minutes do the following  
        if(k==0)
          {// if timer hasnt been started start it
          k=1; // start timer once per selected period 
          j=timeRTC.minute;// store minute value
          j++; //move the timer along by one to prevent chance of immediate trigger of timer trap  
          pc.printf("*****************************start 30 min timer\r\n");
          }
        if(timeRTC.minute!=j)
          {  //if minute value is different from previous value assue 1 minute has expired
          //k=0;
          j=timeRTC.minute;// store new minute value
          l++; //increment minute timer
          pc.printf("***************************** %d minutes have elapsed\r\n",l);
          if (l==30)
             {  // 30 minutes have elapsed so lets save data to the SD card
             l=0; //reset 30 minute counter
             k=0; //reset timer
             lcd.setTextColour(RED);
             lcd.string(15,220,70,238,"Rec", &bytes);
             wait(1);
             pc.printf("***********reset 30 min timer\r\n");
             pc.printf("***********saving to file - 30 minute\r\n");
             writtenBytes=0; //, readbytes=0; //i=0; 
             fres=lcd.SDFwriteFile(messageft, sizeof(messageft), &writtenBytes, WORKSPACE0); //write to the open file in WORKSPACE0 size of message in bytes and store the successfully written Bytes on writtenBytes variable
             die(fres);                         //If any error report it    
             lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
             }
          } 
        }

             
       lcd.setTextColour(WHITE);
      res = lcd.getRTCTimeDate(&timeRTC);
      pc.printf("%d sec %d min %d \r\n",timeRTC.second, timeRTC.minute, storetosd);
     // pc.printf("%d \r\n",timeRTC.minute);
       } //end of storetosd if


        if(lcd.touchScreen(&point)==VALID)
           { //if a touch on screen is valid check which button        
           if(point.y>180 && point.y<215 && point.x<50) 
             { //if the touch on button1 draw the object button1 as SELECTED
             lcd.objButton(10, 180, 50, 215, SELECTED, "EXIT");
             wait_ms(50);
             lcd.objButton(10, 180, 50, 215, DESELECTED, "EXIT");
             pc.printf("EXIT\r\n"); //debug
             but1=1;
             }// end of if button 1 pressed
           }// end of if screen touched
    } //end of main loop while Exit button 
    
    if(storetosd>1 && storetosd<5)
      {  //if data to be captured to sd card close the file properly
       lcd.SDFsaveFile(WORKSPACE0);          //Save changes in the file contained in WORKSPACE0
       //lcd.string(10,row,319,239,"Closing File...",&charsPrinted); row+=15;    
       lcd.SDFcloseFile(WORKSPACE0);         //Close the file --------------------
       }
       pc.printf("SD open file now saved and closed properly\r\n");
       wait(3); // wait to show message before starting the program again
       pc.printf("re-starting the program again\r\n");
       wait(2);
 }// end of total program while statement
 }// end of main program