#include "mbed.h"
#include "PololuLedStrip.h"
#include <iostream>

#define LED_COUNT 36 //was 60

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p13, p14);  // tx, rx to connect to mbed 1

DigitalIn intune(p19);
DigitalIn toohigh(p18);
DigitalIn toolow(p17);
DigitalIn state(p16);
DigitalOut ledd1(LED1);
DigitalOut ledd2(LED2);
DigitalOut ledd3(LED3);
DigitalOut ledd4(LED4);
DigitalIn myInputPin (p21); //select tuner or chord learning mode

char typed[20];

PololuLedStrip ledStrip(p11);

rgb_color colors[LED_COUNT];

Timer timer;

int aMajor[6] = {0,2,2,2,0,-1}; //<<<< CHORDS supported in Chord Mode for LED Strip
int bMajor[6] = {2,4,4,4,2,-1};
int cMajor[6] = {0,1,0,2,3,-1};
int dMajor[6] = {2,3,2,0,-1,-1};
int eMajor[6] = {0,0,1,2,2,0};
int fMajor[6] = {1,-1,2,3,3,1};
int gMajor[6] = {3,0,0,0,2,3};

int lowEstring[6] = {0,11,12,23,24,35}; //<<<< STRINGS supported in Tuner mode for LED strip
int Astring[6] =    {1,10,13,22,25,34};
int Dstring[6] =    {2,9,14,21,26,33};
int Gstring[6] =    {3,8,15,20,27,32};
int Bstring[6] =    {4,7,16,19,28,31};
int HiEstring[6] =  {5,6,17,18,29,30};
/* 
   Above are the various arrays which represent the location of the string
   played in a given fret to achieve a certain chord. The layout
   of this arrangement helps the mBed light up the correct pattern
   of LEDs on the LED strip. Not all of the chords can be played as the
   Solo only includes the first six frets.
*/

int chordCode = 0;
int testResult = 0;
int interpretedChordCode = 0;

using namespace std;

int ledMapping(int fret, int str)
{
    int result;
    // Initialise a variable that represents the specific number of the LED
    // that is to be lit up
    if(fret != -1)
    {
    if(fret%2 != 0)
    // If the fret number is odd...
    {
        result = 6*fret + str - 1;
        // ...then the LED number for that fret corresponds to the above formula
    } else
    // Otherwise if the fret number is even...
    {
        result = 6*(fret + 1) - str;
        // ...then the LED number for that fret corresponds to the above formula
    }
    return result;
    }
    return -1;
    // Output the LED number as a return value so that other parts of the code can
    // use it when this function is called for a specific chord.
}

/*
 * The decoder takes a char value that represents a chord, whether it is sharp or natural and whether
 * it is major or minor. The inputted value for chord is either a capital (major) or lowercase letter (minor).
 * Also assigned is a sharp value (either 0 or 1, where 0 is a natural note and 1 is a sharp)
 */

int decoder(string typed)
{
        int ascii = int(typed[0]);// get the hex value for input char from mbed1
        int chordValue; //set up integer 0-6 to represent A-G for later
        if (65 <= ascii && ascii <= 71) //test if mbed1 input is a major chord A-G
             {
                chordValue = ascii - 65; // it is A-G so set int to appropriate 0-6
              //  pc.printf(" %d ", chordValue);
/*                
                switch (chordValue) { //for diagnostics use putc not printf to send 
            case 0:                   //received char from mbed1 to mbed2's usb pc
                pc.putc('A');
                break;
            case 1:
                pc.putc('B');
                break;
            case 2:
                pc.putc('C');                
                break;
            case 3:
                pc.putc('D');                
                break;
            case 4:
                pc.putc('E');                
                break;
            case 5:
                pc.putc('F');                
                break;
            case 6:
                pc.putc('G');               
                break;
                }
  */                 
              }
return chordValue;
}

int tunerdecoder(string typed)
{
        int ascii = int(typed[0]);// get the hex value for input char from mbed1
        int chordValue; //set up integer 0-6 to represent A-G for later
   //     if (65 <= ascii && ascii <= 71) //test if mbed1 input is a major chord A-G
   //          {
   //             chordValue = ascii - 65; // it is A-G so set int to appropriate 0-6
              //  pc.printf(" %d ", chordValue);
               
                switch (ascii) { //for diagnostics use putc not printf to send 
            case 69:                   //received char from mbed1 to mbed2's usb pc
                pc.putc('E');
                chordValue=0;
                break;
            case 65:
                pc.putc('A');
                chordValue=1;
                break;
            case 68:
                chordValue=2;
                pc.putc('D');                
                break;
            case 71:
                chordValue=3;
                pc.putc('G');                
                break;
            case 66:
                chordValue=4;
                pc.putc('B');                
                break;
            case 101:
                chordValue=5;
                pc.putc('e');                
                break;
        //    case 71:
        //        pc.putc('G');               
        //        break;
        //        }
           
              }
//          if (ascii == 101) //test if mbed1 input is High E sent as 'e'
//             {
//                chordValue = 5;
//              } 
return chordValue;
}


void illuminator (int position, int colour)
{
     //pc.printf ("Position: %d Colour: %d\n",position,colour);
     if (position != -1)
     {
         if (colour == -1) //out of tune
         {
            colors[position] = (rgb_color){40,0,0};
         }
         else if (colour == 0) // processing
         {
            colors[position] = (rgb_color){40,40,40};
         }
         else if (colour == 1) //in tune
         {
            colors[position] = (rgb_color){0,40,0};
         }
         else
         {
            pc.printf ("Error: invalid colour number in illuminator\n");
         }
    }
}

               
                //Possible to change to a case/switch structure improve speed?
int shaper (int shape, int colour)// <<<<<< CHORD SHAPER >>>>>>>
    {   
    if (shape == 0)
       {
       for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(aMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }
    else if (shape == 1)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(bMajor[i],i+1), colour);
           }
        //    feedback(colour);
 
        }
    else if (shape == 2)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(cMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }
    else if (shape == 3)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(dMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }
    else if (shape == 4)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(eMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }
    else if (shape == 5)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(fMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }
    else if (shape == 6)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (ledMapping(gMajor[i],i+1), colour);
           }
        //    feedback(colour);
        }

    // Send the colors to the LED strip.
    ledStrip.write(colors, LED_COUNT);
    return (0);
    }

                //Possible to change to a case/switch structure improve speed?
int Tunershaper (int shape, int colour) // <<<<<<<< TUNER SHAPER >>>>>>>>>
    {   
    if (shape == 0)
       {
       for(int i = 0; i<6; i++)
           {
           illuminator (lowEstring[i], colour);
           }
        //    feedback(colour);
        }
    else if (shape == 1)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (Astring[i], colour);
           }
        //    feedback(colour);
 
        }
    else if (shape == 2)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (Dstring[i], colour);
           }
        //    feedback(colour);
        }
    else if (shape == 3)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (Gstring[i], colour);
           }
        //    feedback(colour);
        }
    else if (shape == 4)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (Bstring[i], colour);
           }
        //    feedback(colour);
        }
    else if (shape == 5)
        {
        for(int i = 0; i<6; i++)
           {
           illuminator (HiEstring[i], colour);
           }
        //    feedback(colour);
        }

    // Send the colors to the LED strip.
   ledStrip.write(colors, LED_COUNT);
    return (0);
    }


void clearLEDstrip() //writes to all the LEDs to clear them
     {
     wait(0.2);
     for(int i=0; i < LED_COUNT ; i++)
        {
        colors[i] = (rgb_color){ 0, 0, 0 };
        }
     ledStrip.write(colors, LED_COUNT);
     }

void callback() //interrupt from serial port from mbed1
           {
           ledd1=1; // received character from mbed1
           typed[0]=device.getc(); //get char from mbed1 via serial port 
           }
int main()
{
    pc.baud (115200); //for pc usb
    device.baud(19200); //for communications with mbed 1
    myInputPin.mode(PullUp);  //set the mbed to use a pullup resistor
    string chord;
    int chordCode;
    setbuf(stdin, NULL);//clear the serial input buffer
    device.attach(&callback);// for serial interupt callback function
    clearLEDstrip();
 
     myInputPin.mode(PullUp);  //set the mbed to use a pullup resistor
     if (myInputPin)  // <<<<SELECT GUITAR TUNER OR CHORD TRAINER FUNCTION>>>
        {
        while(1)
             {
             clearLEDstrip();
             ledd1=0; //received character from mbed1
             ledd2=toolow; //inputs from mbed1 mapped onto mbed 2 LED's 
             ledd3=intune; // 
             ledd4=toohigh;// 
 //           pc.putc(typed[0]); //debugging
             chordCode = tunerdecoder(typed); //takes input char from mbed1 and gives back 0-6 to represent chord selected A-G 
 //          pc.putc(chordCode);
           
           //  shaper(chordCode, 0); //light current chord in white (0)
           //  wait(0.8); //hold it for a period so user can see it 
             if (intune) //read mbed1 intune pin and light the green LEDs
                {
                Tunershaper(chordCode, 1); //green light (1)
                wait(0.4);
                }
             if (toohigh) //read mbed1 toohigh pin and light the red LEDs
                {
                Tunershaper(chordCode, -1); //red light (-1)
                wait(0.4); 
                }  
             if (toolow)//read mbed1 toolow pins and light the red LEDs
                {
                Tunershaper(chordCode, 0); //white light (0)
                wait(0.4); 
                }  
                

       /*      for(int j = 0; j<6; j++)
                {
           //     chordCode=j;
                Tunershaper(chordCode, -1); //red
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
                }
                for(int j = 0; j<6; j++)
                {
           //     chordCode=j;
                Tunershaper(chordCode, 1); //green
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
                }
                 for(int j = 0; j<6; j++)
                {
           //     chordCode=j;
                Tunershaper(chordCode, 0); //green
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
                }
                
                chordCode=0;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);

                chordCode=1;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);

                chordCode=2;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);

                chordCode=3;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
            
                chordCode=4;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
            
                chordCode=5;
                Tunershaper(chordCode, 0); //white
                wait(0.5); 
                ledStrip.write(colors, LED_COUNT);
            */
                            
            //clearLEDstrip();
             }            
        }
     else   //if myinputpin Chord or Tuner mode = Chord mode selected
        {   // >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // ..............CHORD MODE.........................
            // >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
        while(1)
             {
             ledd1=0; //received character from mbed1
             ledd2=intune; //intune input from mbed1 
             ledd3=toohigh; // toohigh input from mbed1
             ledd4=state;// state input from mbed1
                    //          pc.putc(typed[0]); //debugging
             chordCode = decoder(typed); //takes input char from mbed1 and gives back 0-6 to represent chord selected A-G 
             shaper(chordCode, 0); //light current chord in white (0)
             wait(0.8); //hold it for a period so user can see it 
             if (intune) //read mbed1 intune pin and light the green LEDs
                {
                shaper(chordCode, 1); //green light (1)
                wait(0.4);
                }
             if ((toohigh) || (toolow))//read mbed1 toohigh and toolow pins and light the red LEDs
                {
                shaper(chordCode, -1); //red light (-1)
                wait(0.4); 
                }
             clearLEDstrip();
             }
        }       
}