#include "LEDController.h"
#include "mbed.h"

LEDController::LEDController(PinName pin, float flashPeriodCon, bool blinkingModeCon, bool shouldBeOnCon):Dout(pin){
    flashPeriod = flashPeriodCon;
    blinkingMode = blinkingModeCon;
    shouldBeOn = shouldBeOnCon;
    flipper.attach(callback(this, &LEDController::flipperFunction), flashPeriod);
}

void LEDController::toggleBlinkingMode(){
    blinkingMode = !blinkingMode;
}

void LEDController::toggleShouldBeOn(){
    shouldBeOn = !shouldBeOn;
}

bool LEDController::getBlinkingMode(){
    return blinkingMode;
}

void LEDController::checkOnOffState(){
    if (shouldBeOn && !blinkingMode) {
        Dout = 1;
    } 
    if (!shouldBeOn) {
        Dout = 0;
    }
}

void LEDController::flipperFunction(){
    if (shouldBeOn && blinkingMode) Dout = !Dout;
}