/** Simple mbed 5-pin DIN to USB MIDI Converter library
 *Marius Petrut, 2015
 */

#ifndef MBED_MIDI5PIN_H
#define MBED_MIDI5PIN_H
 
#include "mbed.h"
 
class Midi5Pin {
public:
    /** Create a Midi5Pin object with the specified
     * transmit and receive pins
     *
     * @param txPin Transmit pin
     * @param rxPin Receive pin
     */
    Midi5Pin(PinName txPin, PinName rxPin);
    
    /** Send a command to the 5-pin output port
     *
     * @param command The MIDI command byte
     * @param param1 First parameter (depends on command)
     * @param param2 Second parameter (depends on command)
     */
    void write(char command, char param1, char param2);
    
    /** Send a noteOn MIDI message to the 5-pin output
     *
     * @param note MIDI note number
     * @param velocity MIDI note velocity (loudness)
     */
    void noteOn(char note, char velocity);
    
    /** Send a noteOff MIDI message to the 5-pin output
     *
     * @param note MIDI note number
     */
    void noteOff(char note);
    
    /** Send a continuous control message to the 5-pin output
     *
     * @param ccNumber The continuous control message number
     * @param value Value of the continuous control message
     */
    void contCtrl(char ccNumber, char value);
    
    /** Read from the 5-pin input connection and send
     * it to the PC through the USB virtual com port
     *
     */
    void read();
  
private:  
    Serial _pc;
    Serial _uart5pin;
};
 
#endif
 