/* Simple mbed 5-pin DIN to USB MIDI Converter library
Marius Petrut, 2015
*/

#ifndef MBED_MIDI5PIN_H
#define MBED_MIDI5PIN_H
 
#include "mbed.h"
 
class Midi5Pin {
public:
    /// Create a Midi5Pin object with the specified
    /// transmit and receive pins
    Midi5Pin(PinName txPin, PinName rxPin);
    
    /// Send a command to the 5-pin output port
    void write(char command, char param1, char param2);
    
    /// Send a noteOn MIDI message to the 5-pin output
    void noteOn(char note, char velocity);
    
    /// Send a noteOff MIDI message to the 5-pin output
    void noteOff(char note);
    
    /// Send a continuous control message to the 5-pin output
    void contCtrl(char ccNumber, char value);
    
    /// Read from the 5-pin input connection and send
    /// it to the PC through the USB virtual com port
    void read();
  
private:  
    Serial _pc;
    Serial _uart5pin;
};
 
#endif
 