/* Simple mbed 5-pin DIN to USB MIDI Converter library
Marius Petrut, 2015
*/

#include "MIDI_5Pin.h"
#include "mbed.h"

#define NOTE_ON 144
#define CONT_CTRL 176

MIDI_5Pin::MIDI_5Pin(PinName txPin, PinName rxPin) :
    _pc(USBTX, USBRX), _uart5pin(txPin, rxPin) {
        _pc.baud(115200);
        // 31250 is the official specification
        _uart5pin.baud(31250);
    }
 
void MIDI_5Pin::write(char command, char param1, char param2) {
    _uart5pin.putc(command);
    _uart5pin.putc(param1);
    _uart5pin.putc(param2);
}

void MIDI_5Pin::noteOn(char note, char velocity) {
    _uart5pin.putc(NOTE_ON);
    _uart5pin.putc(note);
    _uart5pin.putc(velocity);
}

void MIDI_5Pin::noteOff(char note) {
    _uart5pin.putc(NOTE_ON);
    _uart5pin.putc(note);
    _uart5pin.putc(0);
}

void MIDI_5Pin::contCtrl(char ccNumber, char value) {
    _uart5pin.putc(CONT_CTRL);
    _uart5pin.putc(ccNumber);
    _uart5pin.putc(value);
}

void MIDI_5Pin::read() {
    if (_uart5pin.readable()) {
        _pc.putc(_uart5pin.getc());
    }
}