// Demo program that showcases the simple Midi5Pin library
// capable of MIDI input/ouput using two 5-Pin DIN connectors

#include "mbed.h"
#include "DebounceIn.h"
#include "Midi5Pin.h"

AnalogIn distSensor(p20);
DebounceIn btn_on(p27);
DebounceIn btn_off(p26);
Midi5Pin midi(p13, p14);

int main() {   
    // Initialize buttons
    btn_on.mode(PullUp);
    btn_off.mode(PullUp);
    wait(.001);
    int old_btn_on=0, new_btn_on;
    int old_btn_off=0, new_btn_off;

    char controlMessage = (char)(distSensor*127);

    while (1) {  
        // This reads the serial UART (5-pin Input) and outputs
        // to the USB virtual com port
        midi.read();
        
        // When this button is pressed, MIDI message is sent to the
        // 5-Pin serial Output
        new_btn_on = btn_on;  
        if ((new_btn_on==0) && (old_btn_on==1)) midi.noteOn(60, 100);
        old_btn_on = new_btn_on;
        
        new_btn_off = btn_off;
        if ((new_btn_off==0) && (old_btn_off==1)) midi.noteOff(60);
        old_btn_off = new_btn_off;
        
        // Send continuous control messages from the IR distance
        // sensor to the 5-pin Output
        if ( abs((char)(distSensor*127)-controlMessage) > 2) {
            midi.contCtrl(14, (char)(distSensor*127));
        }
    }
}
