
#include "mbed.h"
#include "VS1002.h"
#include "TextLCD.h"

TextLCD lcd2(p10, p18, p24, p23, p22, p21, TextLCD::LCD16x2 ); // rs, e, d0-d3


/*

 Arduino MP3 Shield MP3Player_UI
 2010/10/10
 This program comes from http://mbed.org/cookbook/VS1002-MP3-Decoder and is the work of xshige.
 (Very small modification done to fit latest libs)
**more small modifications done to add a small user interface via LCD screen, rotary encoder and dipswitch,
see http://mbed.org/cookbook/MP3-Player for more information on pinout for these devices, these UI mods by (mpetersen3 and kbuck3)

 Pin Assigenment for Arduino MP3 Shield
 (VS1053 employed, issued by sparkfun.com)

 MP3 Sheild Side   |  mbed Side
 ---------------------------------------
  D2(BSYNC)------------17
  D3(DREQ)-------------16

  D9(CS)---------------14

  D11(MOSI)------------5
  D12(MISO)------------6
  D13(SCK)-------------7

  GND------------------GND(1)
  5V-------------------VU(39)
  RESET----------------15

 Volume will not used. (pin20 will not used)

*/


//PinName mmosi, PinName mmiso, PinName ssck, PinName ccs, const char *name,
//         PinName mosi, PinName miso, PinName sck, PinName cs, PinName rst,
//         PinName dreq, PinName dcs, PinName vol)
VS1002 mp3(p11, p12, p13, p8, "sd",
           p5, p6, p7, p14, p15,
           p16, p17, p20);     //p14 in BoB non-functional so replace with p18
AnalogIn rotary(p19);
DigitalIn pause(p28);

int main () {
    // make debug port Fast
    Serial pc(USBTX, USBRX);
    pc.baud(9600);


    // pc.baud(115200);
//  pc.baud(230400);

    /*============================================================
     * MP3 Initialising
     *==========================================================*/
#ifndef FS_ONLY
    mp3._RST = 1;
    mp3.cs_high();                                   //chip disabled
    mp3.sci_initialise();                            //initialise MBED
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    mp3.sci_write(0x03, 0x9800);
    mp3.sdi_initialise();
#endif
    /*============================================================
     * This is the good part
     *==========================================================*/
    int a=0;
    printf("%i\n",a);
    while (true) {

        

        
        mp3.play_song(a);
        a++;
        wait(1);
        
        if (pause) {
            while (pause) {
                // shows you which song number you have chosen using the rotary dial
                lcd2.printf("You have chosen the %i song\n",a);
                if ((rotary>0)&&(rotary<=0.1)) {
                    a=1;

                } else if ((rotary>0.1)&&(rotary<=0.2)) {
                    a=2;
                } else if ((rotary>0.2)&&(rotary<=0.3)) {
                    a=3;
                } else if ((rotary>0.3)&&(rotary<=0.4)) {
                    a=4;
                } else if ((rotary>0.4)&&(rotary<=0.5)) {
                    a=5;
                } else if ((rotary>0.5)&&(rotary<=0.6)) {
                    a=6;
                } else if ((rotary>0.6)&&(rotary<=0.7)) {
                    a=7;
                } else if ((rotary>0.7)&&(rotary<=0.8)) {
                    a=8;
                } else if ((rotary>0.8)&&(rotary<=0.9)) {
                    a=9;
                } else if ((rotary>0.9)&&(rotary<=1.0)) {
                    a=10;
                }
            }
            }
        }
        printf("Done.\r\n");
    }
