// This header has all the (extern) declarations of the globals.
// "extern" means "this is instantiated somewhere, but here's what the name
// means.
#include "globals.h"
#include "hardware.h"

// We need to actually instantiate all of the globals (i.e. declare them once
// without the extern keyword). That's what this file does!

// Hardware initialization: Instantiate all the things!
//uLCD_4DGL uLCD(p9,p10,p11);             // LCD Screen (tx, rx, reset)
//SDFileSystem sd(p5, p6, p7, p8, "sd");  // SD Card(mosi, miso, sck, cs)
Serial pc(USBTX,USBRX);                 // USB Console (tx, rx)
//MMA8452 acc(p28, p27, 100000);        // Accelerometer (sda, sdc, rate)
DigitalIn button1(p8);                 // Pushbuttons (pin)
//DigitalIn button2(p22);
//DigitalIn button3(p23);
//DigitalIn button4(p24);
AnalogOut DACout(p18);                  // Speaker (pin)
PwmOut speaker(p26);
//wave_player waver(&DACout);


// Some hardware also needs to have functions called before it will set up
// properly. Do that here.
int hardware_init()
{
    // Crank up the speed
    //uLCD.baudrate(1500000);
    pc.baud(115200);
    
    //Initialize pushbuttons
    button1.mode(PullUp); 
    //button2.mode(PullUp);
    //button3.mode(PullUp);
    //button4.mode(PullUp);
    
    // initialize the accelerometer 
  //  acc.activate();
    
    return ERROR_NONE;
}

UserInputs read_inputs() 
{
    UserInputs inputs;                  // creates the struct for the game inputs 
    
    inputs.b1 = button1.read();               // give a value to button 1 
    //inputs.b2 = button2;                // give a value to button 2
    //inputs.b3 = button3;                // give a value to button 3
    //inputs.b4 = button4;                // give a value to button 4
    
    /*acc.readXGravity(&inputs.ax);       // give a value to x axis 
    acc.readYGravity(&inputs.ay);       // give a value to y axis
    acc.readZGravity(&inputs.az);       // give a value to z axis
     */
    return inputs;
}

