#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "MFRC522.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip   (A2, A3, A4, A5, A0);

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    wait(1);
    RfChip.PCD_Init();
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    wait(1);
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);

    while(1) {
        char buf[64];
        uint8_t status;
        MFRC522::MIFARE_Key key;
        uint8_t type;
        
        // Initialize key to default
        key.keyByte[0] = 0xff;
        key.keyByte[1] = 0xff;
        key.keyByte[2] = 0xff;
        key.keyByte[3] = 0xff;
        key.keyByte[4] = 0xff;
        key.keyByte[5] = 0xff;
        
        if (!RfChip.PICC_IsNewCardPresent()) {
            wait_ms(300);
            continue;
        }
        
        if (!RfChip.PICC_ReadCardSerial()) {
            wait_ms(200);
            continue;
        }
        
        uint8_t i;
        for (i = 0; i < RfChip.uid.size; i++)
        {
            snprintf(buf+i*3, 64-i*3, "%2.2x:", RfChip.uid.uidByte[i]);
        }
        buf[i*3-1] = '\0';
        
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)buf, LEFT_MODE);
        
        type = RfChip.PICC_GetType(RfChip.uid.sak);
        snprintf(buf, 64, "PICC Type: %s", RfChip.PICC_GetTypeName(type));
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)buf, LEFT_MODE);
        
        // Attempt auth
        status = RfChip.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, 1, &key, &RfChip.uid);
        snprintf(buf, 64, "Auth status: %s", RfChip.GetStatusCodeName(status));
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)buf, LEFT_MODE);

        if (status == MFRC522::STATUS_OK)
        {
            // Dump block.
            uint8_t size = sizeof(buf);
            status = RfChip.MIFARE_Read(1, (uint8_t *)buf, &size);
            if (status == MFRC522::STATUS_OK)
            {
                char tmp[64];
                snprintf(tmp, 64, "Read %d bytes at block 1", size);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)tmp, LEFT_MODE);
                
                uint8_t i;
                for (i =0; i < size; i++)
                {
                    snprintf(tmp+i*3, 64-i*3, "%2.2x:", buf[i]);
                }
                tmp[i*3-1] = '\0';
                
                lcd.DisplayStringAt(0, LINE(6), (uint8_t *)tmp, LEFT_MODE);
            }
            else
            {
                lcd.ClearStringLine(5);
            }
        }
        // Close out auth.
        RfChip.PCD_StopCrypto1();
         
//        ts.GetState(&TS_State);
//        if (TS_State.touchDetected) {
//            // Clear lines corresponding to old touches coordinates
//            if (TS_State.touchDetected < prev_nb_touches) {
//                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
//                    lcd.ClearStringLine(idx);
//                }
//            }
//            prev_nb_touches = TS_State.touchDetected;
//
//            cleared = 0;
//
//            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
//            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
//
//            for (idx = 0; idx < TS_State.touchDetected; idx++) {
//                x = TS_State.touchX[idx];
//                y = TS_State.touchY[idx];
//                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
//                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
//            }
//
//            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
//        } else {
//            if (!cleared) {
//                lcd.Clear(LCD_COLOR_BLUE);
//                sprintf((char*)text, "Touches: 0");
//                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
//                cleared = 1;
//            }
//        }
    }
}
