#ifndef _IROBJDETECTOR_H_
#define _IROBJDETECTOR_H_

#include "mbed.h"
#include "tlc5916.h"

#define BRIGHTNESS_BINS 16

class IRObjDetector
{
public:
    IRObjDetector(void) : tlc5916(p6, p5, p7, p11), ain(p18)
    {
        debug           = NULL;
        minBrightness   = 0;
        avgBrightness   = 0;
        maxBrightness   = 0;
        for (currentBin = 0; currentBin < BRIGHTNESS_BINS; currentBin++)
        {
            brightnessBins[currentBin] = 0;
        }        
        currentBin = 0;    
    };
    
    IRObjDetector(Serial *debug) : debug(debug), tlc5916(p6, p5, p7, p11), ain(p18)
    {
        debug           = NULL;
        minBrightness   = 0;
        avgBrightness   = 0;
        maxBrightness   = 0;
        for (currentBin = 0; currentBin < BRIGHTNESS_BINS; currentBin++)
        {
            brightnessBins[currentBin] = 0;
        }        
        currentBin = 0;    
    };
    
    /**
     * Scan through all 7 LED's and store the values.
     */
    void scan(void);
    
    /**
     * Get the centeroid value of the scaned field.
     */
    float get_centeroid(void);
    
    /**
     * Get the 'raw' brightness value.
     */
    uint16_t get_raw_brightness(void);
    uint16_t get_min_brightness(void);
    uint16_t get_avg_brightness(void);
    uint16_t get_max_brightness(void);
    float    get_weighted_avg_brightness(void);
     
private:

    void calc_centeroid(void);
    void calc_contrast(void);

    Serial     *debug;    
    TLC5916     tlc5916;
    AnalogIn    ain;
    uint16_t    data[8]; //Bin 7 is the 'all off' bin.
    float       centeroid;
    uint16_t    brightness;
    uint16_t    brightnessBins[BRIGHTNESS_BINS]; // Used to calculate average brightness
    uint8_t     currentBin;
    uint32_t    avgBrightness;
    uint16_t    maxBrightness;
    uint16_t    minBrightness;

    
    float       mean;
    float       map;
};

#endif //_IROBJDETECTOR_H_