#ifndef _BEACON_H_
#define _BEACON_H_

#include "mbed.h"
#include "MODSERIAL.h"

class Beacon 
{
public:
    Beacon(void) : ainL(p16), ainR(p17) 
    {
        offsL = 0;
        gainL = 1;
        offsR = 0;
        gainR = 1;
    };
    
    void    scan(void);
    void    calibrate(MODSERIAL * debug);
    uint16_t get_max_rssi(void);
    float   get_centeroid(void);
    
    uint16_t getL(void);
    uint16_t getR(void);
    
private:
    uint16_t readAndAverageL(int times);
    uint16_t readAndAverageR(int times);
    
    void calc_centeroid(void);

    AnalogIn ainL;
    AnalogIn ainR;
    
    uint16_t  valL;
    uint16_t  valR;
    
    int32_t   offsL;
    int32_t   gainL;
    int32_t   offsR;
    int32_t   gainR;
    
    uint16_t  max;
    float    centeroid;

};

#endif //_BEACON_H_