#ifndef _TLC5916_H_
#define _TLC5916_H_

class TLC5916 {

public:
    TLC5916(PinName le, PinName sin, PinName clk, PinName nOE) : pinLE(le), pinnOE(nOE), spi(sin, NC, clk)
    {
        pinLE   = 0;
        pinnOE  = 1;
        
        spi.format(8,0);
        spi.frequency(1000000);        
    };
    
    void write_reg(uint8_t byte);
    void enable(void);
    void disable(void);
    
private:

    DigitalOut  pinLE;
    DigitalOut  pinnOE;
    SPI         spi;

};

#endif //_TLC5916_H_