#include "mbed.h"
#include "m3pi.h"
#include "tlc5916.h"

#define DARK_THRESHOLD 0x1A0



AnalogIn    in1(p15);
AnalogIn    in2(p16);
AnalogIn    in3(p17);
AnalogIn    in4(p18);
AnalogIn    in5(p19);
AnalogIn    in6(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

m3pi base;
TLC5916 tlc5916(p6, p5, p7, p11);

int main() {

    struct m3pi::LineSensors sensors;
    uint16_t val1 = 0;
    uint16_t val2 = 0;
    uint8_t  leds = 0x01;
    
    base.reset();
    wait(1);
    
    base.locate(0, 0);
    base.printf("AIN: ");
    
    while (1) {
        if (leds == 0x80)
            leds = 0x01;
        tlc5916.write_reg(leds);
               
        tlc5916.enable();
        wait_us(25);
        led1 = 1;
        val1 = in4.read_u16();
        //val2 = in5.read_u16();
        led1 = 0;
        tlc5916.disable();
        wait(1);
        led2 = 1;
        base.locate(0, 0);
        base.printf("AIN:%4.4x", val1);
        base.locate(0, 1);
        base.printf("AIN:%4.4x", leds);
        led2 = 0;
        leds = leds << 1;
    }
        
#if 0    
    base.sensor_auto_calibrate();
    
    base.locate(0,0);
    base.printf("Sens 3:");
    
    
    while(1) {
    
        sensors = base.get_raw_sensors();
        base.locate(0,1);
        base.printf("0x%4.4x", sensors.sensor3);
        if (sensors.sensor3 > DARK_THRESHOLD) {
            base.right_motor(0.2);
            base.left_motor(-0.2);
        } else {
            base.forward(0.2);
        }
    }
#endif
}
