/**
 * @file    Quaternion.h
 * @author  Mike Panetta
 *
 * Created Oct 29th 2011
 *
 * Based on tutorial here: http://www.cprogramming.com/tutorial/3d/quaternions.html
 *
 */
 
#ifndef _QUATERNION_H_
#define _QUATERNION_H_

#include <math.h>

class Quaternion
{
    public:
        Quaternion(float const & a,
                   float const & b,
                   float const & c,
                   float const & d) : w(a), x(b), y(c), z(d) {}
    
        float norm(void)
        {
            return sqrtf(w*w+x*x+y*y+z*z);
        }
 
        float real(void)
        {
            return w;
        }
        
        Quaternion unreal(void)
        {
            return Quaternion(0, x, y, z);
        }
           
    private:
    
        float w, x, y, z;
};


#endif //_QUATERNION_H)_