#ifndef __IRBEHAVIORCONTROLLER_H__
#define __IRBEHAVIORCONTROLLER_H__

#include "mbed.h"
#include "IRObjDetector.h"
#include "PID.h"

class IRBehaviorController
{
public:
    IRBehaviorController(PID *pid) : pid(pid)
    {
        debug               = NULL;
        activationThreshold = 0.0f;
        brightness          = 0.0f;
        output              = 0.0f;        
    };
    
    IRBehaviorController(PID * pid, Serial * debug) : debug(debug), ird(debug), pid(pid)
    //IRBehaviorController(PID * pid, Serial * debug) : debug(debug), pid(pid) 
    {
        activationThreshold = 0.0f;
        brightness          = 0.0f;
        output              = 0.0f;
    };
    
    void setAvoidanceBehavior(float threshold);
    void setSeekingBehavior(float threshold);
    
    void setActiveThreshold(float threshold);   // Brightness level at which behavior is active.
    
    void runAvoidance(void);                    // Execute avoidance behavior
    void runSeeking(void);                      // Execute seeking behavior
    
    float getPower(void);                       // Returns the power value needed to execute the behavior.
    float getBrightness(void);
    float getCenteroid(void);
    
    void  dumpDebug(Serial *debug);
    
private:

    void            scanIR(void);

    Serial          *debug;
    
    IRObjDetector   ird;
    PID             *pid;
    
    float           activationThreshold;             // Brightness threshold at which behavior is active.
    float           brightness;
    float           centeroid;
      
    float           output;
};
#endif