#ifndef __PID_H__
#define __PID_H__

#include "mbed.h"

class PID
{
public:
    PID(float i_p, float i_i, float i_d) : 
        k_p(i_p), k_i(i_i), k_d(i_d)
        {
            debug      = NULL;
            
            v_p        = 0.0f;
            v_i        = 0.0f;
            v_d        = 0.0f;
            
            clip       = 1.0f;
            error      = 0.0f;
            prev_error = 0.0f;
        }

    PID(float i_p, float i_i, float i_d, Serial *debug) : 
        debug(debug), k_p(i_p), k_i(i_i), k_d(i_d)
        {
            v_p        = 0.0f;
            v_i        = 0.0f;
            v_d        = 0.0f;
            
            clip       = 1.0f;
            error      = 0.0f;
            prev_error = 0.0f;
        }
        
    void  setP(float p);       // set k_p
    void  setI(float i);       // set k_i
    void  setD(float d);       // set k_d
    void  setClip(float clip);
    void  setPV(float pv);     // Set process variable (PID input)
    float getOutput(void);     // Get PID output.
    
    void  run(void);           // Callback to be called via Ticker to execute the PID algo.
    float run(float in);       // Version to run PID in place (not via timer or interrupt)
    
    void dumpDebug(Serial *debug);    
    
private:
    Serial *debug;

    float k_p, k_i, k_d; // PID constants
    float v_p, v_i, v_d; // PID variables
    float clip;   // Integral clip value (absolute)
    float error;
    float prev_error;
    float output;

};

#endif