/*
#include "mbed.h"
#include "FT_Platform.h"
#include "Image.h"
#include "pictures.h"
#include "PinDetect.h"
#include "mbcrc.h"
#include <string> 

PinDetect Up(PF_4);
PinDetect Down(PF_5);
PinDetect Left(PF_2);
PinDetect Right(PF_3);
PinDetect Ok(PF_1);
DigitalOut ho(PF_0);

int menuNamber = 0;
int virtualButtonNamber = 0;

 
void main_menu(uint32_t tracker, uint8_t tag);
void LoadImagesAndFonts(void);
void HandleAllBitmaps(void);
void StartDL(void);
void FinishDL(void);
void show_logo(void);
void show_logo1(void);
int tagoption = 0;

unsigned char command[8]={0x03,0x06,0x20,0x00,0x00,0x01,0x00,0x00};

//Serial pc(SERIAL_TX, SERIAL_RX); //test
Serial RS485(PA_9, PA_10);
FT800 TFT( PE_6, PE_5, PE_2, PE_4, PC_13, PC_15);
//       ( mosi, miso, sclk,   ss,  intr,  pd );

void send_command_to_RS485(unsigned char cmd)
{
    RS485.format(8, Serial::None, 1);
    RS485.baud(9600);
    uint16_t crc16;
    crc16 = usMBCRC16( ( unsigned char * ) command, 6 );
    command[5] = cmd;
    command[6] = ( unsigned char )( crc16 >> 8 );
    command[7] = ( unsigned char )( crc16 & 0xFF );
    
    ho = 1;                  // 3.3V output from digital out pin
    RS485.putc(command[0]);   // slave add
    RS485.putc(command[1]);   // function code
    RS485.putc(command[2]);   // Hi PDU add
    RS485.putc(command[3]);   // low PDU add
    RS485.putc(command[4]);   // Hi N reg 
    RS485.putc(command[5]);   // Lo N reg
    RS485.putc(command[6]);   // Hi CRC
    RS485.putc(command[7]);   // Lo CRC
    ho=0;
}

 
void main_menu(uint32_t tracker, uint8_t tag)
{
    time_t seconds = time(NULL); 
    //start new display list
    StartDL();
 
    TFT.DL(TAG(0));                         // assign TAG value 0 to everything else
    //TFT.Calibrate(0);
    
    //TFT.DL(BEGIN(BITMAPS));
    //TFT.DL(VERTEX2II(11, 15, 0, 0) );
    //TFT.DL(END());

    switch(virtualButtonNamber){
        default: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 30, 0, "Button1"); break; }
        case 1: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 30, 0, "Up"); break;} 
        case 2: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 30, 0, "Down"); break;} 
        case 3: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 30, 0, "Left"); break;} 
        case 4: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 31, 0, "Right"); break;} 
        case 5: {TFT.Button(((TFT.DispWidth/2)-100), TFT.DispHeight/2, 400, 80, 31, 0, "Ok"); break;} 
    
    }
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/24, 31, OPT_CENTERX, "Menu\0"); 
 
    TFT.Button(100, 80, 600, 100, 31, 0, "Automatic mode"); //B1
    TFT.Button(100, 200, 600, 100, 31, 0, "Manual mode"); //B2

 
    TFT.Text((TFT.DispWidth/4), TFT.DispHeight*7/8, 28, OPT_CENTERX, "Run time [s]: \0");        // draw Text with font 31
    TFT.Number((TFT.DispWidth/2), (TFT.DispHeight*7/8),28,OPT_CENTERX, seconds);
 
    TFT.DL(COLOR_RGB(0xFF,  0x00,   0x00));
    TFT.Text((TFT.DispWidth*7/8)+9, (TFT.DispHeight*15/16), 28, OPT_CENTERX, "by Denis Nyzovets\0");            // draw Text with font 31
 
    //display the screen
    FinishDL();
}

void StartDL(void)
{
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));
}

void FinishDL(void)
{
    TFT.DL(DISPLAY());
    TFT.Swap();
    TFT.Flush_Co_Buffer();
    TFT.WaitCmdfifo_empty();
}

void show_logo(void)
{
    /*
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_LOGO);
    TFT.WrCmdBufFromFlash(logo, sizeof(logo));

    StartDL();
    TFT.DL(BITMAP_HANDLE(0));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_LOGO));
    TFT.DL(BITMAP_LAYOUT(ARGB1555, 0, 309));
    //TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 840, 480));
    TFT.DL(BITMAP_SIZE(BILINEAR, BORDER, BORDER, 0, 309));
    FinishDL();

    StartDL();
    TFT.DL(BEGIN(BITMAPS));
    TFT.DL(VERTEX2II(0, 0, 0, 0));
    TFT.DL(END());
    FinishDL();
    */
}

void LoadImagesAndFonts(void)
{
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_HUMIDITY);
    TFT.WrCmdBufFromFlash(hum_icon, sizeof(hum_icon));
    /*
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_TEMPERATURE);
    TFT.WrCmdBufFromFlash(temp_icon, sizeof(temp_icon));   
       
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_SENSOR);
    TFT.WrCmdBufFromFlash(HYT_photo, sizeof(HYT_photo));

    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(FONT_SET_ROBOTO_REGULAR_30);
    TFT.WrCmdBufFromFlash(font_RobotoRegular30, sizeof(font_RobotoRegular30));
    
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(FONT_SET_ROBOTO_REGULAR_16);
    TFT.WrCmdBufFromFlash(font_RobotoRegular16, sizeof(font_RobotoRegular16));
    */
}


void HandleAllBitmaps(void)
{
    StartDL();
    TFT.DL(BITMAP_HANDLE(0));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_HUMIDITY));
    TFT.DL(BITMAP_LAYOUT(ARGB4, 60, 38));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 30, 38));
    /*
    TFT.DL(BITMAP_HANDLE(1));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_TEMPERATURE));
    TFT.DL(BITMAP_LAYOUT(ARGB4, 42, 42));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 21, 42));
        
    TFT.DL(BITMAP_HANDLE(2));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_SENSOR));
    TFT.DL(BITMAP_LAYOUT(RGB332, 101, 147));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 101, 147));
    
    TFT.DL(BITMAP_HANDLE(3));
    TFT.DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_30));
    TFT.DL(BITMAP_LAYOUT(L4, 16, 33));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 33));

    TFT.DL(BITMAP_HANDLE(4));
    TFT.DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_16));
    TFT.DL(BITMAP_LAYOUT(L4, 8, 20));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 16, 20));
    
    TFT.SetFont(3, FONT_SET_ROBOTO_REGULAR_30);
    TFT.SetFont(4, FONT_SET_ROBOTO_REGULAR_16);
    */    
    FinishDL();
}

void up_callback (void) {
    virtualButtonNamber=1;
}

void down_callback (void) {
    virtualButtonNamber=2;
}

void left_callback (void) {
    virtualButtonNamber=3;
}

void right_callback (void) {
    virtualButtonNamber=4;
}

void ok_callback (void) {
    virtualButtonNamber=5;
}

int main(void)
{
    Up.mode(PullUp);    
    Down.mode(PullUp);
    Left.mode(PullUp);
    Right.mode(PullUp);
    Ok.mode(PullUp);
    wait(.01);
    
    Up.attach_deasserted(&up_callback);
    Down.attach_deasserted(&down_callback);
    Left.attach_deasserted(&left_callback);
    Right.attach_deasserted(&right_callback);
    Ok.attach_deasserted(&ok_callback);
    
    Up.setSampleFrequency();
    Down.setSampleFrequency();
    Left.setSampleFrequency();
    Right.setSampleFrequency();
    Ok.setSampleFrequency();
    
   //pc.printf("Press '1' to turn LED1 ON, '0' to turn it OFF\n");
   //DigitalOut led(LED1); led=1;
   //screen1(0x0,0x0);
   set_time(0);  // Set RTC time to 0
   wait(1);
   //TFT.Logo();
  
   DigitalOut led2(LED2); led2=1;
   //TFT.WaitLogo_Finish();
   //LoadImagesAndFonts();
   //HandleAllBitmaps();
   while(1) main_menu(0x0,0x0);
      
   //show_logo1();
   return 0;
}
*/