#include "Stepper.h"
#include "mbed.h"
 
stepper::stepper(PinName _en, PinName _stepPin, PinName dir):en(_en),
    stepPin(_stepPin),
    direction(dir)
{
}
 
void stepper::step(int microstep, int dir, float speed)
{
    if (dir == 1) {
        direction = 0;
    } else if (dir == 0) {
        direction = 1;
    }
    
    stepPin = 1;
    wait(1/speed);
    stepPin = 0;
    wait(1/speed);
}
 
void stepper::enable()
{
    en = 0;
}
 
void stepper::disable()
{
    en = 1;
}