#include "mbed.h"
#include "FT_Platform.h"
#include "Image.h"
#include "pictures.h"
#include "mbcrc.h"
#include "parameters.h"
#include <string>

DigitalOut ho(PF_0); 

typedef enum {
    NONE_PRESS,
    BUTTON_1_PRESS,
    BUTTON_2_PRESS,
    BUTTON_3_PRESS,
    BUTTON_LEFT,
    BUTTON_RIGHT,
    MENU_PRESS,
} pressValues;

// all screens available in app
typedef enum {
    MENU_SCREEN,
    AUTOMATIC_SCREEN,
    MANUAL_SCREEN,
    CALIBRATION_SCREEN,
} screenValues;

char pressedButton;
char activeScreen;

 
void main_menu(void);
void LoadImagesAndFonts(void);
void HandleAllBitmaps(void);
void StartDL(void);
void FinishDL(void);
void show_logo(void);
void show_logo1(void);

unsigned char command[8]={0x03,0x06,0x20,0x00,0x00,0x01,0x00,0x00};

Serial RS485(PA_9, PA_10);
FT800 TFT( PE_6, PE_5, PE_2, PE_4, PC_13, PC_15); //(mosi, miso, sclk,   ss,  intr,  pd );



void send_command_to_RS485(unsigned char cmd)
{
    RS485.format(8, Serial::None, 1);
    RS485.baud(9600);
    uint16_t crc16;
    crc16 = usMBCRC16( ( unsigned char * ) command, 6 );
    command[5] = cmd;
    command[6] = ( unsigned char )( crc16 >> 8 );
    command[7] = ( unsigned char )( crc16 & 0xFF );
    
    ho = 1;                   // En high
    RS485.putc(command[0]);   // slave add
    RS485.putc(command[1]);   // function code
    RS485.putc(command[2]);   // Hi PDU add
    RS485.putc(command[3]);   // low PDU add
    RS485.putc(command[4]);   // Hi N reg 
    RS485.putc(command[5]);   // Lo N reg
    RS485.putc(command[6]);   // Hi CRC
    RS485.putc(command[7]);   // Lo CRC
    ho=0;                     // En low
}

void CalibrationTS()
{       
    char calibration[25] = {98, 99, 0, 0, 182, 254, 255, 255, 245, 142, 248, 255, 117, 254, 255, 255, 34, 98, 0, 0, 123, 154, 248, 255}; //value for calibration TS, must be changed!!!
    for (int i = 0; i < 24; i++) {
        TFT.Wr8(REG_TOUCH_TRANSFORM_A + i, calibration[i]);
    }
}

 
void main_menu()
{   
    StartDL();

    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/24, 31, OPT_CENTERX, "Menu\0"); 
    
    TFT.DL(TAG_MASK(1));
    TFT.DL(TAG(BUTTON_1_PRESS));
    TFT.FgColor(0x703800);
    // if rectangle is already pressed, draw it lighter
    //if (pressedButton == BUTTON_1_PRESS)  TFT.FgColor(0x387000);
    TFT.Button(100, 80, 600, 100, 31, 0, "Automatic mode"); //B1
    TFT.DL(TAG_MASK(0));

    TFT.DL(TAG_MASK(1));
    TFT.DL(TAG(BUTTON_2_PRESS));
    TFT.FgColor(0x387000);            
    TFT.Button(100, 200, 600, 100, 31, 0, "Manual mode"); //B2
    TFT.DL(TAG_MASK(0));
    
    TFT.DL(TAG_MASK(1));
    TFT.DL(TAG(BUTTON_3_PRESS));        
    TFT.FgColor(0x387000);
    TFT.Button(100, 320, 600, 100, 31, 0, "Calibration mode"); //B3
    TFT.DL(TAG_MASK(0));

 
    TFT.Text((TFT.DispWidth/4), TFT.DispHeight*7.5/8, 28, OPT_CENTERX, "Button: \0");        // draw Text with font 31
    TFT.Number((TFT.DispWidth/2), (TFT.DispHeight*7.5/8),28,OPT_CENTERX, pressedButton);

    FinishDL();
}

void automatic_menu()
{
    StartDL();
 
    TFT.DL(TAG(0));                         // assign TAG value 0 to everything else
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/24, 31, OPT_CENTERX, "Automatic mode\0");
    
    
    //TFT.FgColor(0x703800);
    TFT.FgColor(0x387000);
    TFT.Button(100, 80, 100, 100, 31, 0, "<"); //B1
    TFT.FgColor(0x387000);
    TFT.Button(400, 80, 100, 100, 31, 0, ">"); //B2
    
    
    
    TFT.Number((TFT.DispWidth/2), (TFT.DispHeight*7/8),31,OPT_CENTERX, pressedButton);
    
    
    TFT.Text((TFT.DispWidth/2), 80, 31, OPT_CENTERX, "Radius (mm):\0");
    TFT.Text((TFT.DispWidth/2), 200, 31, OPT_CENTERX, "Number:\0");
    TFT.Text((TFT.DispWidth/2), 320, 31, OPT_CENTERX, "Run out (mm):\0");
    

    FinishDL();
}

void manual_menu()
{
    StartDL();
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/24, 31, OPT_CENTERX, "Manual mode\0"); 
 
    //display the screen
    FinishDL();
}


void calibration_menu()
{
    StartDL();
 
    TFT.DL(TAG(0));                         // assign TAG value 0 to everything else
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/24, 31, OPT_CENTERX, "Calibration\0"); 
 
    //display the screen
    FinishDL();
}

void StartDL(void)
{
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));
}

void FinishDL(void)
{
    TFT.DL(DISPLAY());
    TFT.Swap();
    TFT.Flush_Co_Buffer();
    TFT.WaitCmdfifo_empty();
}

void show_logo(void)
{
    /*
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_LOGO);
    TFT.WrCmdBufFromFlash(logo, sizeof(logo));

    StartDL();
    TFT.DL(BITMAP_HANDLE(0));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_LOGO));
    TFT.DL(BITMAP_LAYOUT(ARGB1555, 0, 309));
    //TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 840, 480));
    TFT.DL(BITMAP_SIZE(BILINEAR, BORDER, BORDER, 0, 309));
    FinishDL();

    StartDL();
    TFT.DL(BEGIN(BITMAPS));
    TFT.DL(VERTEX2II(0, 0, 0, 0));
    TFT.DL(END());
    FinishDL();
    */
}

void LoadImagesAndFonts(void)
{
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_HUMIDITY);
    TFT.WrCmdBufFromFlash(hum_icon, sizeof(hum_icon));
    /*
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_TEMPERATURE);
    TFT.WrCmdBufFromFlash(temp_icon, sizeof(temp_icon));   
       
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(IMAGE_ADDR_SENSOR);
    TFT.WrCmdBufFromFlash(HYT_photo, sizeof(HYT_photo));

    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(FONT_SET_ROBOTO_REGULAR_30);
    TFT.WrCmdBufFromFlash(font_RobotoRegular30, sizeof(font_RobotoRegular30));
    
    TFT.WrCmd32(CMD_INFLATE);
    TFT.WrCmd32(FONT_SET_ROBOTO_REGULAR_16);
    TFT.WrCmdBufFromFlash(font_RobotoRegular16, sizeof(font_RobotoRegular16));
    */
}


void HandleAllBitmaps(void)
{
    StartDL();
    TFT.DL(BITMAP_HANDLE(0));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_HUMIDITY));
    TFT.DL(BITMAP_LAYOUT(ARGB4, 60, 38));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 30, 38));
    /*
    TFT.DL(BITMAP_HANDLE(1));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_TEMPERATURE));
    TFT.DL(BITMAP_LAYOUT(ARGB4, 42, 42));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 21, 42));
        
    TFT.DL(BITMAP_HANDLE(2));
    TFT.DL(BITMAP_SOURCE(IMAGE_ADDR_SENSOR));
    TFT.DL(BITMAP_LAYOUT(RGB332, 101, 147));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 101, 147));
    
    TFT.DL(BITMAP_HANDLE(3));
    TFT.DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_30));
    TFT.DL(BITMAP_LAYOUT(L4, 16, 33));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 33));

    TFT.DL(BITMAP_HANDLE(4));
    TFT.DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_16));
    TFT.DL(BITMAP_LAYOUT(L4, 8, 20));
    TFT.DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 16, 20));
    
    TFT.SetFont(3, FONT_SET_ROBOTO_REGULAR_30);
    TFT.SetFont(4, FONT_SET_ROBOTO_REGULAR_16);
    */    
    FinishDL();
}

int main(void)
{
    TFT.Calibrate();
    //CalibrationTS();
    //DigitalOut led2(LED2); led2=1;
    activeScreen = MENU_SCREEN;
    pressedButton = NONE_PRESS;
    main_menu();
   
    while(1) {
      wait_ms(9000);  
        pressedButton = TFT.Rd8(REG_TOUCH_TAG);
        
        switch(activeScreen)   
        {  
            case MENU_SCREEN: {
                main_menu();
                if (pressedButton == BUTTON_1_PRESS) {activeScreen = AUTOMATIC_SCREEN; pressedButton = NONE_PRESS; break;}
                else if (pressedButton == BUTTON_2_PRESS) {activeScreen = MANUAL_SCREEN; pressedButton = NONE_PRESS; break;}
                else if (pressedButton == BUTTON_3_PRESS) {activeScreen = CALIBRATION_SCREEN; pressedButton = NONE_PRESS; break;}
            }
            case AUTOMATIC_SCREEN: automatic_menu();  
            case MANUAL_SCREEN: manual_menu();
            case CALIBRATION_SCREEN: calibration_menu();
            break;
        }
        
        
   }
}



















      /*

nt main(void)
{
    TFT.Calibrate();
    //CalibrationTS();
    //DigitalOut led2(LED2); led2=1;
    activeScreen = MENU_SCREEN;
    pressedButton = NONE_PRESS;
    main_menu();
   
    while(1) {
        
        pressedButton = TFT.Rd8(REG_TOUCH_TAG);
        
        switch(activeScreen)   
        {  
            case MENU_SCREEN: main_menu();  
            case AUTOMATIC_SCREEN: automatic_menu();  
            case MANUAL_SCREEN: manual_menu();
            case CALIBRATION_SCREEN: calibration_menu()
        }
        
        if (activeScreen == MENU_SCREEN) {
            main_menu();
            if (pressedButton) {
                wait_ms(10);
                if (pressedButton == BUTTON_1_PRESS) {activeScreen = AUTOMATIC_SCREEN;} 
                else if (pressedButton == BUTTON_2_PRESS) {activeScreen = MANUAL_SCREEN;}
                else if (pressedButton == BUTTON_3_PRESS) {activeScreen = CALIBRATION_SCREEN;}
                pressedButton = NONE_PRESS;
            }
        }
        else {
            switch(activeScreen)
            if (activeScreen == AUTOMATIC_SCREEN ) automatic_menu();
            else if (activeScreen == MANUAL_SCREEN) manual_menu();
            else if (activeScreen == CALIBRATION_SCREEN) calibration_menu();
            
            }
        
        
  
        if (activeScreen == MENU_SCREEN) {
            main_menu();
            if (pressedButton) {
                    wait_ms(150);
                if (pressedButton == BUTTON_1_PRESS) {
                    activeScreen = AUTOMATIC_SCREEN;
                } else if (pressedButton == BUTTON_2_PRESS) {
                    activeScreen = MANUAL_SCREEN;
                } else if (pressedButton == BUTTON_3_PRESS) {
                    activeScreen = CALIBRATION_SCREEN;
                }
                pressedButton = NONE_PRESS;
            }
        else {
            if (activeScreen == AUTOMATIC_SCREEN ) automatic_menu();
            else if (activeScreen == MANUAL_SCREEN) manual_menu();
            else if (activeScreen == TEST_SCREEN) calibration_menu();
            
            }
        pressedButton = NONE_PRESS;
   }
}
*/