#include "Tiltmeter.h"

#include "math.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Paste your code from the pre-lab assignment here

const float PI = atan(1.0) * 4.0;
const float Rad2Deg = 180.0 / PI;

Tiltmeter::Tiltmeter()
{
   // initialize the roll and pitch angles
   RollAngle = 0.0;
   PitchAngle = 0.0;
}


void Tiltmeter::ComputeTiltAngles()
{
   // read the acceleometers and store them
   ReadAccelerometers();
   float a_x = GetAccelX();
   float a_y = GetAccelY();
   float a_z = GetAccelZ();

   // normalize the measurements
   float a = sqrt( a_x * a_x + a_y * a_y + a_z * a_z );
   a_x /= a;
   a_y /= a;
   a_z /= a;

   // compute roll and pitch
   RollAngle = atan2( -a_x, a_z ) * Rad2Deg;
   PitchAngle = atan2( a_y, sqrt( a_x * a_x + a_z * a_z ) ) * Rad2Deg;
}


float Tiltmeter::GetRoll() const
{
   return RollAngle;
}


float Tiltmeter::GetPitch() const
{
   return PitchAngle;
}