#include "ENGO333_I2C.h"

ENGO333_I2C::ENGO333_I2C(PinName sda, PinName scl) : i2c(sda, scl)
{
    // Do nothing
}

ENGO333_I2C::~ENGO333_I2C()
{
    // Do nothing
}

void ENGO333_I2C::setSpeed(int freq)
{
    this->i2c.frequency(freq);
}

void ENGO333_I2C::writeOneByte(char deviceAddress, char registerAddress, char value)
{
    char temp[2];
    temp[0] = registerAddress;
    temp[1] = value;
    this->i2c.write(deviceAddress, temp, 2);
}

char ENGO333_I2C::readOneByte(char deviceAddress, char registerAddress)
{
    char temp = 0;
    this->i2c.write(deviceAddress, &registerAddress, 1);
    this->i2c.read(deviceAddress, &temp, 1);
    return (char)temp;
}

void ENGO333_I2C::readBytes(char deviceAddress, char registerAddress, char* value, int length)
{
    this->i2c.write(deviceAddress, &registerAddress, 1);
    this->i2c.read(deviceAddress, value, length);
}

