#include "mbed.h"
#include "MMA7660.h"                // accelerometer sensor
#include "C12832.h"                 // LCD display


int main() 
{  
    
    // create an accelerometer object
    MMA7660 accelerometer(p28, p27);
    
    // LCD display
    C12832 lcd(p5, p7, p6, p8, p11);
    
    // joystick
    BusIn joystick(p15,p12,p13,p16);
    
    //the push button of the joystick ("fire" will be 1 is the push button is pressed)
    DigitalIn fire(p14);
    
    // Left LED ("leftled" will be zero, when the led is off, and 1 when the led is on)
    DigitalOut leftled(LED1);
    
    // All LEDs
    BusOut LEDs(LED1, LED2, LED3, LED4);

    // try to establish a connection with the accelerometer
    if( !accelerometer.testConnection() )
    {
        // turn on all LEDs (indicating an error state)
        LEDs = 0xf;
        return 0;
    }

    // clear the LCD screen    
    lcd.cls();
    
    
    // TODO: Move to the centre of the LCD and set the corresponding pixel to black
    //       We will call the current location the "active pixel"

   
    // create an infinite loop (i.e., the program runs as long as the processor is on)
    while(1)                                                       
    {
        // TODO: Get the state/value of the joystick
        
        
        // TODO: Determine the coordinates of the next active pixel based on joystick data
        
        
        // TODO: Set the next pixel to black (the pixel color can be black or off!)
        
        
        
        // TODO: Get the accelerometer measurements
        
    

        // TODO: Check if the screen should be cleared based on the accelerometer 
        //       measurements, and if so:
                 // clear the screen and move the active pixel to the center of the screen again
                 // trun the left LED on for 0.1 seconds and turn it off again.
        //
        //       NOTE: Although you may have an idea of how to do this, it may take some
        //             "tuning" to get it to "feel right". 
       

     
        // wait a short period
        wait(0.1);
    }
    
    // end of program
    return 0;
}
