#include "mbed.h"                   // General board
#include "MMA7660.h"                // accelerometer sensor
#include "C12832.h"                 // LCD display

//Some ideas: 
// create a for loop to turn the LED on and off with a pattern. For example, every 1 second.
// create a condition to turn the LED on when the joystick fire pin is pressed, and turn it off when any other pin is pressed

int main() 
{  
    // Variables
    int x, y, joy, press;
    float accX, accY, accZ, acc3;
    
    // create an accelerometer object
    MMA7660 accelerometer(p28, p27);
    
    // LCD display object
    C12832 lcd(p5, p7, p6, p8, p11);
    
    //An external LED powered by pin 30
    DigitalOut redled(p30);
    redled = 1; //1 means the LED is turned on
    wait(2.0); //Make the program pause for 2 seconds
    redled=0; // 0 means the LED is turned off
    
    // joystick object
    BusIn joystick(p15,p12,p13,p16);
    DigitalIn fire(p14);
    
    // Left LED
    DigitalOut leftled(LED1); 
    
    //A way to manipulate all the LEDs together
    BusOut LEDs(LED1, LED2, LED3, LED4);

    // try to establish a connection with the accelerometer
    if( !accelerometer.testConnection() )
    {
        // turn on all LEDs (indicating an error state)
        LEDs = 0xf;
        return 0;
    }

    // clear the LCD        
    lcd.cls();
    
    
    // TODO: Move to the centre of the LCD and set the corresponding pixel to black
    //       We will call the current location the "active pixel"
    x = lcd.width() / 2;
    y = lcd.height() / 2;
    lcd.pixel(x, y, 1);
    lcd.copy_to_lcd();
   
    // create an infinite loop (i.e., the program runs as long as the processor is on)
    while(1)                                                       
    {
        // TODO: Get the state/value of the joystick
        joy = joystick.read();
        
        // TODO: Determine the coordinates of the next active pixel based on joystick data
        if (joy == 1 && y > 0) // UP
        { 
            --y;
        } 
        else if (joy == 2 && y < lcd.height() - 1) // DOWN
        { 
            ++y;
        } else if (joy == 4 && x > 0) // LEFT
        { 
            --x;
        } 
        else if (joy == 8 && x < lcd.width() - 1) // RIGHT
        {   
            ++x;
        } 
        else if (joy == 5 && x > 0 && y > 0) // LEFT-UP
        {    
            --x;
            --y;
        } 
        else if (joy == 6 && x > 0 && y < lcd.height() - 1) // LEFT-DOWN
        {     
            --x;
            ++y;
        } 
        else if (joy == 9 && x < lcd.width() - 1 && y > 0) // RIGHT-UP
        { 
            ++x;
            --y;
        } 
        else if (joy == 10 && x < lcd.width() - 1 && y < lcd.height() - 1) 
        {  // RIGHT-DOWN
            ++x;
            ++y;
        }
        
        // TODO: Set the next pixel to black
        lcd.pixel(x, y, 1);
        lcd.copy_to_lcd();

        
        
        // TODO: Get the accelerometer measurements
        
        accX = accelerometer.x();
        accY = accelerometer.y();
        accZ = accelerometer.z();
        acc3 = sqrt(accX * accX + accY * accY + accZ * accZ); //this the amount of acceleration (how fast you displace or shake the board!)

        // TODO: Check if the screen should be cleared based on the accelerometer 
        //       measurements, and if so, clear the screen but don't move the active 
        //       pixel.
        //
        //       NOTE: Although you may have an idea of how to do this, it may take some
        //             "tuning" to get it to "feel right". 
       
        if (acc3 > 1.5 || fire ) {
            
            lcd.cls();
            x = lcd.width() / 2;
            y = lcd.height() / 2;
            lcd.pixel(x, y, 1);
            lcd.copy_to_lcd();
            
            leftled=1;
            wait(0.2);
            leftled=0;
            
        }

     
        // wait a short period
        wait(0.1);
    }
    
    // end of program
    return 0;
}
