#include "mbed.h"

// Machine UP/DOWN (LEFT)
DigitalOut UP_DOWN_1(P0_8);   //8
DigitalOut UP_DOWN_2(P1_25);  //25

// Belt Combare Rolling (C_LEFT)
DigitalOut BELT_ROLL_1(P0_2);  //2
DigitalOut BELT_ROLL_2(P1_24);  //24

// Belt Combare Moving (Upper M/C)
DigitalOut BELT_MOVE_1(P0_0);
DigitalOut BELT_MOVE_2(P1_4);

// Machine Move FW/CFW (C_RIGHT / RIGHT)
DigitalOut FW_CFW_1(P1_27);
DigitalOut FW_CFW_2(P1_18);

// Catch Action (Upper M/C)
DigitalOut CATCH_1(P0_10);
DigitalOut CATCH_2(P0_15);

// LED 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut led5(P0_9);

// Sensor Input
AnalogIn Sensor_read(P0_22);

// Switch Input
DigitalIn UP(P0_12);
DigitalIn DOWN(P0_13);
DigitalIn BELT_ROLL_FW(P0_18);
DigitalIn BELT_ROLL_CFW(P0_19);
DigitalIn BELT_MOVE_FW(P0_17);
DigitalIn BELT_MOVE_CFW(P1_17);
DigitalIn FW(P0_16);
DigitalIn CFW(P0_14);

Ticker wari;
Ticker moto;

char flag = 1;
unsigned char times = 0;

void stop(){                                // Interrupt Routine
    float sens = Sensor_read;
    flag = 1;
    if(sens > 0.6){
        UP_DOWN_1 = 1;
        UP_DOWN_2 = 1;
        led1 = 0;
        flag = 0;
    }
}

void rev(){
    BELT_ROLL_1 = 0;
    BELT_ROLL_2 = 1;
    led5 = 1;
}

void matsu(){
    times++;
}


void jikan_1(){
    FW_CFW_2 = 0;
    FW_CFW_1 = 1;
    led2 = 1;
    wait(0.0003);
    
    FW_CFW_1 = 0;
    wait(0.001);
}

void jikan_2(){
    FW_CFW_2 = 1;
    FW_CFW_1 = 0;
    led2 = 1;
    wait(0.0003);
    FW_CFW_2 = 0;
    wait(0.001);
}
    
int main() {
    wari.attach_us(&stop,100000);
    moto.attach(&matsu,1);
    
    // rolling
    BELT_ROLL_1 = 1;
    BELT_ROLL_2 = 0;
    
    while(1){
        if(times == 10){
            rev();
        }else if(times > 11){
            BELT_ROLL_1 = 1;
            BELT_ROLL_2 = 0;
            led5 = 0;
            times = 0;
        }
        if(flag == 1){
            if(UP == 0 && DOWN == 1){
              UP_DOWN_1 = 1;
              UP_DOWN_2 = 0;
              led1 = 1;
            }
        }
        
        if(UP == 1 && DOWN == 0){
            UP_DOWN_1 = 0;
            UP_DOWN_2 = 1;
            led1 = 1;
        }else if(UP == 0 && DOWN == 0){
            UP_DOWN_1 = 1;
            UP_DOWN_2 = 1;
            led1 = 0;
        }
        
        if(FW == 1 && CFW == 0){
            jikan_1();
        }else if(FW == 0 && CFW == 1){
            jikan_2();
        }else if(FW == 0 && CFW == 0){
            FW_CFW_1 = 0;
            FW_CFW_2 = 0;
            led2 = 0;
        }
        
        if(BELT_ROLL_FW == 1 && BELT_ROLL_CFW == 0){
            CATCH_1 = 1;
            CATCH_2 = 0;
            led4 = 1;
        }else if(BELT_ROLL_FW == 0 && BELT_ROLL_CFW == 1){
            CATCH_1 = 0;
            CATCH_2 = 1;
            led4 = 1;
        }else if(BELT_ROLL_FW == 0 && BELT_ROLL_CFW == 0){
            CATCH_1 = 1;
            CATCH_2 = 1;
            led4 = 0;
        }
        
        if(BELT_MOVE_FW == 1 && BELT_MOVE_CFW == 0){
            BELT_MOVE_1 = 1;
            BELT_MOVE_2 = 0;
            led3 = 1;
        }else if(BELT_MOVE_FW == 0 && BELT_MOVE_CFW == 1){
            BELT_MOVE_1 = 0;
            BELT_MOVE_2 = 1;
            led3 = 1;
        }else if(BELT_MOVE_FW == 0 && BELT_MOVE_CFW == 0){
            BELT_MOVE_1 = 1;
            BELT_MOVE_2 = 1;
            led3 = 0;
        }
        }
    }