# Moxon Design mbed OS V5 BLE UartService to USBUART passthru

This guide reviews the steps required to get BLU UART working on an mbed OS platform.

Please install [mbed CLI](https://github.com/ARMmbed/mbed-cli#installing-mbed-cli).

## Import the example application

From the command-line, import the example:

```
mbed import MoxDes-mbed-os-BLE-USB-passthru
cd MoxDes-mbed-os-BLE-USB-passthru
```

### Now compile

Invoke `mbed compile`, and specify the name of your platform and your favorite toolchain (`GCC_ARM`, `ARM`, `IAR`). For example, for the ARM Compiler 5:

```
mbed compile -m nRF42-DK -t ARM
```


### Program your board

1. Connect your mbed device to the computer over USB.
1. Copy the binary file to the mbed device.
1. Press the reset button to start the program.

The BLE device should advertise as "BLART" (BLe-uART)

## Export the project to Keil MDK, and debug your application

From the command-line, run the following command:

```
mbed export -m nRF42-DK -i uvision
```

To debug the application:

1. Start uVision.
1. Import the uVision project generated earlier.
1. Compile your application, and generate an `.axf` file.
1. Make sure uVision is configured to debug over CMSIS-DAP (From the Project menu > Options for Target '...' > Debug tab > Use CMSIS-DAP Debugger).
1. Set breakpoints, and start a debug session.

![Image of uVision](img/uvision.png)

## Troubleshooting

1. Make sure `mbed-cli` is working correctly and its version is `>1.0.0`

 ```
 mbed --version
 ```

 If not, you can update it:

 ```
 pip install mbed-cli --upgrade
 ```

2. If using Keil MDK, make sure you have a license installed. [MDK-Lite](http://www.keil.com/arm/mdk.asp) has a 32 KB restriction on code size.