#include "mbed.h"
#include "rtos.h"
#include "cmsis_os.h"
#include "SDFileSystem.h"

DigitalOut led1(D7);
DigitalOut led2(D9);
Serial uart1(D8, D2);                        /* UART1: Modbus               */
Serial uart2(D1, D0);                        /* UART2: pc(USBTX, USBRX)     */
                                             /* (i.e.) pc(D1, D0)           */
I2C i2c(I2C_SDA, I2C_SCL);                   /* I2C1:                       */
                                             
SDFileSystem sd(D11, D12, D13, D10, "sd");   /* SPI1: MOSI, MISO, SCK, CS   */
FILE *fp;

AnalogIn ain_0(A0);
AnalogIn ain_1(A1);
AnalogIn ain_2(A2);
AnalogIn ain_3(A3);

InterruptIn user_sw_1(USER_BUTTON);

/* N.B. - add to the FRU... */
//const char key[] = "your_api_key";    // Replace with your API key
//const char feed[] = "your_feed_id";   // Replace with your Feed ID
//const char stream[] = "your_stream_name"; // Replace with your stream name  
//char name[] = "your_device_location_name"; // Name of current location of datasource
//double latitude = 30.3748076;
//double longitude = -97.7386896; // You can also read those values from a GPS
//double elevation = 400.00;

void led2_thread(void const *args){
    while (true) {
        led1 = led2;
        led2 = !led2;
        osDelay(1000);
    }
}

void uart1_thread(const void *args){
    uart1.baud(9600);
    while(true){
        uart1.putc(uart1.getc());
    }
}
void uart2_thread(const void *args){
    uart2.baud(9600);
    while(true){
        uart2.putc(uart2.getc());
    }
}

osThreadDef(uart1_thread, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(uart2_thread, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(led2_thread, osPriorityNormal, DEFAULT_STACK_SIZE);

int main() {
    
    /* Set RTC time to 16 December 2013 10:05:23 UTC */
    set_time(1387188323);
    /* Time as seconds since January 1, 1970 */
    time_t seconds = time(NULL); /*  */
    
    osThreadCreate(osThread(led2_thread), NULL);
    osThreadCreate(osThread(uart1_thread), NULL);
    wait(1);
    
    uart2.printf("\r\n");
    wait(1);
    uart2.printf("Initializing...\r\n");
    
    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        uart2.printf("Remove an existing file with the same name\r\n");
    }
    
    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
        uart2.printf("Unable to write the file\r\n");
    } else {
        fprintf(fp, "mbed SDCard application!");
        fclose(fp);
        uart2.printf("File successfully written!\r\n");
    }
    
    osThreadCreate(osThread(uart2_thread), NULL);
    
    Thread::wait(osWaitForever);    /* this is better than an infinite loop... */
    /* spin and spin */    
    // while(true);
}
