#ifndef ESTRELA_H_
#define ESTRELA_H_

#include "mbed.h"

//===========OUT channel======================
/*
Servo servo_AIL1(SERVO8);
Servo servo_ELE(SERVO7);
Servo servo_THR(SERVO6);
Servo servo_RUD(SERVO5);
Servo servo_O(SERVO4);
Servo servo_AIL2(SERVO3);
*/
//===========IN channel======================

//===========machine setting=================

/*<<<<<<<<<< Tips >>>>>>>>>
サーボ入出力は0~1000(us)　これはPWMのパルス幅である
だけど機体によってトリムがあるので、サーボ初期位置は必ず500とは限らない
あたりまえだけど、プロポのほうの設定変更（舵角やミキシング量等）はここには反映されない
反映したけりゃ自分でこのファイルを書き直すこと

AIL エルロン
ELE エレベーター
THR スロットル
RUD ラダー
SW1 (7ch)
SW2 (8CH)

*/
//1ch   AIL1
//2ch   ELE
//3ch   THR
//4ch   RUD
//6cH   AIL2


/*自動操縦スイッチのしきい値　ch7のトリムやEPAを変えたらかならずチェックすること*/
#define SWITCH_CHECK 1400    //下1052　上1972
/*各舵のニュートラル値*/
#define RUD_N 1573           //  L   1790   N   1332    R   1032    width   822
#define THR_N 1508           //  low 1184   N   1507    hi  1832    width   813
#define ELE_N 1461           //  up  1192   N   1412    dow 1690    width   739
/*各舵の最大値*/
#define RUD_MAX 1836
#define ELE_MAX 1628
/*各舵の最小値*/
#define RUD_MIN 1262
#define ELE_MIN 1304
#define THR_MIN 1416
/*各舵のリバース設定　１かー１のみ　直接掛け算するので*/
#define THROTTLE_REV 1
#define ELEVATOR_REV 1 //1
#define RUDDER_REV 1   //1
/*各舵の比例ゲイン値*/
#define THROTTLE_GN 0.2
#define ELEVATOR_GN 1   //0.9
#define RUDDER_GN 1  //0.6
/*各舵の微分ゲイン*/
#define ELE_DGN 0.5
#define RUD_DGN 0.5
/*旋回時のラダー中心位置*/
#define RUDDER_TURN 164
/*旋回時のロール角度*/
#define SENKAI_D 10
/*通常迎角*/
#define GEIKAKU 31
/*機体設置状態ピッチ方向の傾き*/
#define LAND_ANGLE 5
/*旋回　積分量設定*/
#define SENKAIDDD 10000000 //旋回時間　傾きの積分値と比較
/*落下機構の動作位置*/
#define OTEDAMA1 710
#define OTEDAMA2 500
#define OTEDAMA3 250

#define CHECKSW1_t 0.1

#define MANUAL_t 0.5
#define SCALE_t 0.05
#define GHPF 512
#define ALPF 32
#define ALPF_ 528

#define MANUAL_MS 25
#define CHECKMODE_MS 0
#define SENSING_MS 0
#define AUTO_MS 25
//#define G_MS 50
//#define A_MS 50
#define MOBIUS_T 144
#define MOBIUS_NN 12
#define MOBIUS_LO 60

//=====================================================

//===============global===============
int Auto_RUD=RUD_N;
int Auto_ELE=ELE_N;
int Auto_THR=THR_N;


#endif /* ESTRELA_H_ */

/*
x軸回り    ロール
y軸回り    ピッチ
z軸回り    ヨー
*/