#include "mbed.h"
#include "LPD8806.h"

#include "SDFileSystem.h"

#define CMD_WAITDUR 0x01
#define CMD_NEXTIMAGE 0x02
#define CMD_START 0x03
#define CMD_STOP 0x04
#define CMD_TIMER_START 0x05
#define CMD_TIMER_STOP 0x06

#define LINE_SCAN_MIN_US 2900

SDFileSystem sd(p11, p12, p13, p14, "sd"); // the pinout on the mbed Cool Components workshop board
 
//DigitalOut myled(LED1);

//sensor in
InterruptIn sensorIn(p8);

//bitmap
struct BITMAPFILEHEADER
{
    uint16_t bfType;
    uint32_t bfSize;
    uint16_t bfReserved1;
    uint16_t bfReserved2;
    uint32_t bfOffBits;
};

struct BITMAPINFOHEADER {
    uint32_t biSize;
    uint32_t biWidth;
    uint32_t biHeight;
    uint16_t biPlanes;
    uint16_t biBitCount;
    uint32_t biCompression;
    uint32_t biSizeImage;
    uint32_t biXPelsPerMeter;
    uint32_t biYPelsPerMeter;
    uint32_t biClrUsed;
    uint32_t biClrImportant;
};

LPD8806 strip = LPD8806(128);
bool loop = true;
uint8_t* buff = NULL;
uint8_t colormap[256];

Serial pc(USBTX, USBRX);
uint8_t serialBuff[16] = {0};
int buffIndex = 0;


//local file system
LocalFileSystem local("data"); 
FILE* fp = NULL;
BITMAPFILEHEADER bmfh;
BITMAPINFOHEADER bmih;

int16_t waitUS = 0;

int imageFileIndex = 0;

int blackOut = 1;
int readNext = 0;

int maxImageFileNum = 0;

int bLoop = 0;

Timer t;
uint32_t interval_wheel = 0;
double interval_wheel_lowpass = 0.0;

Ticker t_speed;

double km_per_h = 0.0;
double last_km_per_h = 0.0;

//speed sensor interrupt
void p8intr()
{
    interval_wheel = t.read_us();
    //limit 50km/h:13752
    if(interval_wheel <= 15280) return;
    
    interval_wheel_lowpass = 0.9*interval_wheel_lowpass + 0.1*(double)interval_wheel;
    last_km_per_h = km_per_h;
    km_per_h = 687600.0/interval_wheel_lowpass;
    
    //zero 
    //if((int)(km_per_h*1000.0) == (int)(last_km_per_h*1000.0)){
    //    km_per_h = 0.0;
    //    last_km_per_h = 0.0;
    //    interval_wheel_lowpass = 0.0;
    //}
    
    int needscantime = interval_wheel_lowpass * 0.18455497382199;
    waitUS = needscantime - LINE_SCAN_MIN_US;
    if(waitUS < 0){
        waitUS = 0;
    }
            
    t.reset();
    t.start();
    
    //pc.printf("OK\n");
}

//send speed data timer callback
void sendSpeed()
{
    pc.printf("%f\n", km_per_h);
}

int getMaxImageFileNum()
{
    char fname[32];
    int i;
    
    for(i=0; i<32; i++){
        sprintf(fname, "/sd/img%03d.bmp", i);
        fp = fopen(fname, "rb");
        if(fp == NULL){
            pc.printf("error\r\n");
            pc.printf("max file num %d", i);
            return i;
        }     
    }
    
    return i-1;
    
}
// ヘッダ情報の表示
void disp_file()
{
    pc.printf("[bitmap file header]\n");
    pc.printf("         bfType = %x [%s]\n",bmfh.bfType,(char*)&bmfh.bfType);
    pc.printf("         bfSize = %d [byte]\n",bmfh.bfSize);
    pc.printf("    bfReserved1 = %d\n",bmfh.bfReserved1);
    pc.printf("    bfReserved2 = %d\n",bmfh.bfReserved2);
    pc.printf("      bfOffBits = %d\n",bmfh.bfOffBits);
    pc.printf("\n");
}
 

// ヘッダ情報の表示
void disp_info()
{
    pc.printf("[bitmap info header]\n");
    pc.printf("         biSize = %d [byte]\n",bmih.biSize);
    pc.printf("        biWidth = %d\n",bmih.biWidth);
    pc.printf("       biHeight = %d\n",bmih.biHeight);
    /*pc.printf("       biPlanes = %d\n",bmih.biPlanes);
    pc.printf("     biBitCount = %d\n",bmih.biBitCount);
    pc.printf("  biCompression = %d\n",bmih.biCompression);
    pc.printf("    biSizeImage = %d\n",bmih.biSizeImage);
    pc.printf("biXPelsPerMeter = %d\n",bmih.biXPelsPerMeter);
    pc.printf("biYPelsPerMeter = %d\n",bmih.biYPelsPerMeter);
    pc.printf("      biClrUsed = %d\n",bmih.biClrUsed);
    pc.printf(" biClrImportant = %d\n",bmih.biClrImportant);
    pc.printf("\n");*/
}

int openBitMapFile(char* filename)
{
    fp = fopen(filename, "rb");
    
    if(fp == NULL){
        pc.printf("error\r\n");
        if(buff != NULL){
            free(buff);
            buff = NULL;
        }
        return 0;
    }
    
    if(buff != NULL){
        free(buff);
        buff = NULL;
    }
        
    /*for(int i=0; i<100; i++){
        uint8_t c;
        fread(&c, sizeof(uint8_t), 1, fp);
        pc.printf("%d %02x\n", i, c);
    }*/
    
    
    fread(&bmfh.bfType,sizeof(uint16_t),1,fp);
    fread(&bmfh.bfSize,sizeof(uint32_t),1,fp);
    fread(&bmfh.bfReserved1,sizeof(uint16_t),1,fp);
    fread(&bmfh.bfReserved2,sizeof(uint16_t),1,fp);
    fread(&bmfh.bfOffBits,sizeof(uint32_t),1,fp);
    //disp_file();
    
    fread(&bmih.biSize,sizeof(uint32_t),1,fp);
    fread(&bmih.biWidth,sizeof(uint32_t),1,fp);
    fread(&bmih.biHeight,sizeof(uint32_t),1,fp);
    fread(&bmih.biPlanes,sizeof(uint16_t),1,fp);
    fread(&bmih.biBitCount,sizeof(uint16_t),1,fp);
    fread(&bmih.biCompression,sizeof(uint32_t),1,fp);
    fread(&bmih.biSizeImage,sizeof(uint32_t),1,fp);
    fread(&bmih.biXPelsPerMeter,sizeof(uint32_t),1,fp);
    fread(&bmih.biYPelsPerMeter,sizeof(uint32_t),1,fp);
    fread(&bmih.biClrUsed,sizeof(uint32_t),1,fp);
    fread(&bmih.biClrImportant,sizeof(uint32_t),1,fp);
    //disp_info();
    
    buff = (uint8_t*)malloc(sizeof(uint8_t)*bmih.biWidth*3);
    for(int i=0; i<bmih.biWidth*3; i++){
        buff[i] = 0;
    }
    
    return 1;
    
    //uint32_t data;
    //fread(&data, sizeof(uint32_t), 1, fp);
    /*fread(&g, sizeof(uint8_t), 1, fp);
    fread(&b, sizeof(uint8_t), 1, fp);
    pc.printf("%d %d %d", r, g, b);*/
    
    //fclose(fp);
    
    
    
}

// Chase a dot down the strip
// good for testing purposes
void colorChase(uint32_t c, uint32_t delay) {
    int i;
 
    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, 0);  // turn all pixels off
    }
 
    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        if (i == 0) {
            strip.setPixelColor(strip.numPixels()-1, 0);
        } else {
            strip.setPixelColor(i-1, 0);
        }
        strip.show();
        wait_ms(delay);
    }
}

void serial_rx()
{
    uint8_t c = pc.getc();
    
    if(c == 0xFF){
        buffIndex = 0;
    }
    else{
        serialBuff[buffIndex] = c;
        buffIndex ++;
        if(buffIndex == 2){
            /*if(serialBuff[0] == CMD_WAITDUR){
                waitMS = (uint16_t)serialBuff[1];
            }*/
            
            if(serialBuff[0] == CMD_NEXTIMAGE){
                readNext = 1;
                
                /*fclose(fp);
                char fname[16];
                sprintf(fname, "image%03d.bmp", imageFileIndex);
                openBitMapFile(fname);
                imageFileIndex ++;
                if(imageFileIndex >= MAX_IMAGE_FILE){
                    imageFileIndex = 0;
                }*/
            }   
            if(serialBuff[0] == CMD_START){
                if(blackOut == 1){
                    blackOut = 0;
                    rewind(fp);
                    fseek(fp,bmfh.bfOffBits,SEEK_SET);
                }
            }
            if(serialBuff[0] == CMD_STOP){
                blackOut = 1;
            }
            
            if(serialBuff[0] == CMD_TIMER_START){
                interval_wheel = 0;
                t.reset();
                t.start();
            }
            
            if(serialBuff[0] == CMD_TIMER_STOP){
                interval_wheel = 0;
                t.stop();
            }
            buffIndex = 0;
                  
        }
        
    }
    
    //loop = false;
    
    //pc.printf("%c", sd);
    
}

int main() {
    
    //open serial connection
    pc.attach(serial_rx, Serial::RxIrq);
    pc.baud(38400);
    //pc.printf("hello mbed!\r\n");
    
    t_speed.attach_us(sendSpeed, 100000);
    
    //get max image file in SD card
    maxImageFileNum = getMaxImageFileNum();
    
    //create color map
    for(int i=0; i<256; i++){
        colormap[i] = i/2;
    }
    
    strip.begin();
    strip.show();
        
    t.start();
    
    //open bitmap file
    if( openBitMapFile("/sd/img000.bmp") != 1){
        
        //strip.begin();
 
        //strip.show();
        
        while(1){
            colorChase(strip.Color(127,0,0), 10);
        }
    }
        
    // Start up the LED strip
    //strip.begin();
    // Update the strip, to start they are all 'off'
    //strip.show();
    
    int line = 0;
    
    //attach interrupt
    sensorIn.fall(&p8intr);
    sensorIn.mode(PullUp);
    
    while (loop) {
 
        //zero 
        /*if(fabs(last_km_per_h - km_per_h) < 0.0001){
            km_per_h = 0.0;
            last_km_per_h = 0.0;
            interval_wheel_lowpass = 0.0;
        }*/
    
        //if(interval_wheel != 0){
            //int needscantime = interval_wheel_lowpass * 0.18455497382199;
            //waitUS = needscantime - LINE_SCAN_MIN_US;
            //if(waitUS < 0){
            //    waitUS = 0;
            //}
            //pc.printf("%d", interval_wheel);
        //}
        
        if(readNext==1){
            readNext = 0;
            
            fclose(fp);
            //wait_us(interval_wheel/10);
            
            char fname[32];
            sprintf(fname, "/sd/img%03d.bmp", imageFileIndex);
            //pc.printf("%s", fname);
            openBitMapFile(fname);
            imageFileIndex ++;
            if(imageFileIndex >= maxImageFileNum){
                 imageFileIndex = 0;
            }
            
            line = 0;
        }
        
        if(blackOut == 0){
            fread(buff, sizeof(uint8_t), bmih.biWidth*3, fp);
            for(int i=0; i<bmih.biWidth; i++){
                strip.setPixelColor(bmih.biWidth-1-i, colormap[buff[3*i+2]], colormap[buff[3*i+1]], colormap[buff[3*i]]); 
                strip.setPixelColor(bmih.biWidth+i, colormap[buff[3*i+2]], colormap[buff[3*i+1]], colormap[buff[3*i]]); 
                //pc.printf("%d %d %d %d %d\n", line, i, buff[3*i+2], buff[3*i+1], buff[3*i]);
            }
            strip.show();
            wait_us(waitUS);
        
            line ++;
            if(line >= bmih.biHeight){
                
                if(bLoop){
                    line = 0;
                    rewind(fp);
                    fseek(fp,bmfh.bfOffBits,SEEK_SET); // Seek to Pixel Area
                }
                else{
                    line = 0;
                    blackOut = 1;
                }
                    
                pc.putc(0xFF); //send finish one image
            }
        }   
    
        else{
            for(int i=0; i<strip.numPixels(); i++){
                strip.setPixelColor(i, 0, 0, 0);
            }
            strip.show();
        }
        
        /*colorChase(strip.Color(127,127,127), 10);
 
        // Send a simple pixel chase in...
        colorChase(strip.Color(127,0,0), 1);      // full brightness red
        colorChase(strip.Color(127,127,0), 1);    // orange
        colorChase(strip.Color(0,127,0), 1);        // green
        colorChase(strip.Color(0,127,127), 1);    // teal
        colorChase(strip.Color(0,0,127), 1);        // blue
        colorChase(strip.Color(127,0,127), 1);    // violet*/
        
        //pc.printf("hello mbed!\r\n");
    }
    
    //fclose(fp);
}

