#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include <string>

LCD_DISCO_F429ZI lcd;
AnalogIn analog_value(PA_0); //Using pin PA0 for analog input
AnalogIn analog_value1(PA_1);
DigitalOut led(LED1);       //Making the LED on if below 1V

extern void start_lcd();
extern void draw_grid();
extern void draw_sin(float, int, int);


int main()
{
    start_lcd();
    float meas_r, meas_v, meas_r1, meas_v1;
    int clock_timer = 0;
    while(1) 
    {
        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 2.92; // Converts value in the 0V-3.3V range
        meas_r1 = analog_value1.read();
        meas_v1 = meas_r1 * 2.92;
        
        char output_number[16];
        char output_number1[16];
        sprintf( output_number, "In 1 : %.2f V", meas_v);
        sprintf( output_number1, "In 2 : %.2f V", meas_v1);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *) output_number , CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *) output_number1 , CENTER_MODE);
          
        draw_sin(meas_v, clock_timer, 0);
        draw_sin(meas_v1, clock_timer, 1);
        
        if (meas_v < 1) 
            led = 1; // LED ON
 
        else 
            led = 0; // LED OFF

        if (clock_timer == 240)
        {
            clock_timer = 0;
            lcd.Clear(LCD_COLOR_WHITE);;
            draw_grid();
        }
        else
            clock_timer++;
            
  //      wait(0.1); // 10th of a second
    }
}

void start_lcd()
{
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    wait(0.3);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"DISCOVERY BOARD", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"STM32F429", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"By: Teddy Sosnowski", CENTER_MODE);
    wait(1);
    lcd.Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font16);
    draw_grid();
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_BLACK);
}
void draw_sin(float location, int x_axis, int input_number)
{
    int y_axis = location * 24;      
    y_axis = 180 - y_axis;
    //Center at pixel 120x180 for grid
    if (input_number == 0)
        BSP_LCD_DrawPixel(x_axis, y_axis, LCD_COLOR_RED);
    else
        BSP_LCD_DrawPixel(x_axis, y_axis, LCD_COLOR_GREEN);
}      

void draw_grid()
{
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_DrawHLine(0, 180, 240); //240X320 screen size
    BSP_LCD_DrawVLine(2, 98, 164);
    BSP_LCD_DisplayChar(5, 85 , 'V');
    BSP_LCD_DisplayChar(225, 160, 'T');
    lcd.SetTextColor(LCD_COLOR_GRAY);

    BSP_LCD_DrawHLine(0, 156, 36);
    BSP_LCD_DrawHLine(0, 132, 36);
    BSP_LCD_DrawHLine(0, 108, 36);
    BSP_LCD_DrawHLine(0, 204, 36);
    BSP_LCD_DrawHLine(0, 228, 36);
    BSP_LCD_DrawHLine(0, 252, 36);

    BSP_LCD_DrawVLine(20, 177, 6);
    BSP_LCD_DrawVLine(40, 177, 6);
    BSP_LCD_DrawVLine(60, 177, 6);
    BSP_LCD_DrawVLine(80, 177, 6);
    BSP_LCD_DrawVLine(100, 177, 6);
    BSP_LCD_DrawVLine(120, 177, 6);
    BSP_LCD_DrawVLine(140, 177, 6);
    BSP_LCD_DrawVLine(160, 177, 6);
    BSP_LCD_DrawVLine(180, 177, 6);
    BSP_LCD_DrawVLine(200, 177, 6);
    BSP_LCD_DrawVLine(220, 177, 6);  
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_BLACK);  
}