#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include <math.h>

LCD_DISCO_F429ZI lcd;

DigitalOut green(LED1, 0);
DigitalOut red(LED2, 1);

InterruptIn button(USER_BUTTON);

uint8_t str1[30], str2[30];

int qsecs = 0;
int seconds = 0;
int minutes = 0;
int hours = 0;

float multiplier = 9.5;

int radius = 70;
int centerx = 120;
int centery = 240;

float delaytime = 0.25;

struct save
{
    bool exists;
    int h;
    int m;
    int s;
}one, two;

void button_pressed()
{
    
    one.exists = 1;
    one.h = hours;
    one.m = minutes;
    one.s = seconds;
    
    red = 0;
    green = 1;   
    hours = 0; 
    minutes = 0;
    seconds = 0;
    qsecs = 0;
    
    lcd.Clear(LCD_COLOR_WHITE);
}

void button_notpressed()
{
   green = 0; 
   red = 0;
}

void DrawClock(int second)
{
    
    if (second == 0)
        lcd.Clear(LCD_COLOR_WHITE);

    double angle = second/multiplier;
    double endx = centerx+radius*sin(angle);
    double endy = centery-radius*cos(angle);
    lcd.DrawCircle(centerx, centery, radius);
    lcd.DrawLine(centerx, centery, endx, endy);
}

int main()
{   
    BSP_LCD_SetFont(&Font20);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Timer Program", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"Mohammad Mustafa", CENTER_MODE);
    wait(2);
    lcd.Clear(LCD_COLOR_WHITE);
    
    one.exists = 0;
    
    while(1)
    {
        button.rise(&button_pressed);
        button.fall(&button_notpressed);
            
        if(button.read()==0)   
        {
            red = !red; 
            qsecs++;
        }   
        if(qsecs%4 == 0 && qsecs != 0)
        {
            qsecs = 0;
            seconds++;
        }
            
        if(seconds%60 == 0 && seconds != 0)
        {
            seconds = 0;
            minutes++;
        }
        if(minutes%12 == 0 && minutes != 0)
        {   
            minutes = 0;
            hours++;
        }
        
        if(one.exists)
        {
            sprintf((char*)str1, "Last Time: %d:%d:%d", one.h, one.m, one.s);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&str1, LEFT_MODE);
        }
        
        sprintf((char*)str1, "HR:MIN:SEC:qSEC");
        sprintf((char*)str2, "%d:%d:%d:%d", hours, minutes, seconds, qsecs);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&str1, CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(7), (uint8_t *)&str2, CENTER_MODE);
        
        DrawClock(seconds%60);
        wait(delaytime);
    }
}



